/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.util.Random;
import org.lsmp.djep.rpe.RpCommandList;
import org.lsmp.djep.rpe.RpEval;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.Variable;

public class RpSpeed {
    static JEP j;
    static int num_itts;
    static long seed;
    static int num_vals;

    static {
        num_itts = 1000000;
        num_vals = 1000;
    }

    public static void main(String[] args) {
        long t1 = System.currentTimeMillis();
        RpSpeed.initJep();
        long t2 = System.currentTimeMillis();
        System.out.println("Jep initialise " + (t2 - t1));
        RpSpeed.doAll("5", new String[0]);
        RpSpeed.doAll("x", new String[]{"x"});
        RpSpeed.doAll("1+x", new String[]{"x"});
        RpSpeed.doAll("x^2", new String[]{"x"});
        RpSpeed.doAll("x*x", new String[]{"x"});
        RpSpeed.doAll("5*x", new String[]{"x"});
        RpSpeed.doAll("cos(x)", new String[]{"x"});
        RpSpeed.doCos();
        RpSpeed.doAll("1+x+x^2", new String[]{"x"});
        RpSpeed.doAll("1+x+x^2+x^3", new String[]{"x"});
        RpSpeed.doAll("1+x+x^2+x^3+x^4", new String[]{"x"});
        RpSpeed.doAll("1+x+x^2+x^3+x^4+x^5", new String[]{"x"});
        RpSpeed.doAll("1+x(1+x(1+x(1+x(1+x))))", new String[]{"x"});
        RpSpeed.doHorner();
        RpSpeed.doAll("if(x>0.5,1,0)", new String[]{"x"});
        RpSpeed.doAll("1*2*3+4*5*6+7*8*9", new String[0]);
        RpSpeed.doAll("x1*x2*x3+x4*x5*x6+x7*x8*x9", new String[]{"x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9"});
        RpSpeed.doAll("cos(x)^2+sin(x)^2", new String[]{"x"});
    }

    public static void doAll(String eqn, String[] varNames) {
        System.out.println("\nTesting speed for \"" + eqn + "\"");
        seed = System.currentTimeMillis();
        try {
            j.parse(eqn);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Variable[] vars = new Variable[varNames.length];
        Double[][] varVals = new Double[varNames.length][num_vals];
        Random generator = new Random(seed);
        int i = 0;
        while (i < vars.length) {
            vars[i] = j.getVar(varNames[i]);
            int j = 0;
            while (j < num_vals) {
                varVals[i][j] = new Double(generator.nextDouble());
                ++j;
            }
            ++i;
        }
        long tj = RpSpeed.doJep(eqn, vars, varVals);
        long tr = RpSpeed.doRpe(eqn, vars, varVals);
        System.out.println("Speed up:\t" + tj / tr);
    }

    static void initJep() {
        j = new JEP();
        j.addStandardConstants();
        j.addStandardFunctions();
        j.addComplex();
        j.setAllowUndeclared(true);
        j.setImplicitMul(true);
        j.setAllowAssignment(true);
    }

    static long doJep(String eqn2, Variable[] vars, Double[][] vals) {
        long tdiff = 0L;
        try {
            Node node = j.parse(eqn2);
            long t1 = System.currentTimeMillis();
            int i = 0;
            while (i < num_itts) {
                int j = 0;
                while (j < vars.length) {
                    vars[j].setValue(vals[j][i % num_vals]);
                    ++j;
                }
                RpSpeed.j.evaluate(node);
                ++i;
            }
            long t2 = System.currentTimeMillis();
            tdiff = t2 - t1;
            System.out.println("Using Jep:\t" + (t2 - t1));
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
        }
        return tdiff;
    }

    static long doRpe(String eqn2, Variable[] vars, Double[][] vals) {
        long tdiff = 0L;
        try {
            Node node3 = j.parse(eqn2);
            RpEval rpe = new RpEval(j);
            RpCommandList list = rpe.compile(node3);
            int[] refs = new int[vars.length];
            int i = 0;
            while (i < vars.length) {
                refs[i] = rpe.getVarRef(vars[i]);
                ++i;
            }
            long t1 = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < num_itts) {
                int j = 0;
                while (j < vars.length) {
                    rpe.setVarValue(refs[j], vals[j][i2 % num_vals]);
                    ++j;
                }
                rpe.evaluate(list);
                ++i2;
            }
            long t2 = System.currentTimeMillis();
            tdiff = t2 - t1;
            System.out.println("Using RpEval2:\t" + (t2 - t1));
            rpe.cleanUp();
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
            e.printStackTrace();
        }
        return tdiff;
    }

    static void doCos() {
        Double[] varVals = new Double[num_vals];
        Random generator = new Random(seed);
        int j = 0;
        while (j < num_vals) {
            varVals[j] = new Double(generator.nextDouble());
            ++j;
        }
        long t1 = System.currentTimeMillis();
        int i = 0;
        while (i < num_itts) {
            double x = varVals[i % num_vals];
            double d = Math.cos(x);
            ++i;
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Using Java:\t" + (t2 - t1));
    }

    static void doHorner() {
        Double[] varVals = new Double[num_vals];
        Random generator = new Random(seed);
        int j = 0;
        while (j < num_vals) {
            varVals[j] = new Double(generator.nextDouble());
            ++j;
        }
        long t1 = System.currentTimeMillis();
        int i = 0;
        while (i < num_itts) {
            double x = varVals[i % num_vals];
            double y = 1.0 + x * (1.0 + x * (1.0 + x * (1.0 + x * (1.0 + x))));
            ++i;
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Using Java:\t" + (t2 - t1));
    }
}

