/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.VectorJep;
import org.nfunk.jep.Node;

public class MRpSpeed {
    static MatrixJep mj;
    static VectorJep vj;
    static int num_itts;

    static {
        num_itts = 100000;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            num_itts = Integer.parseInt(args[0]);
        }
        System.out.println("VectorJep, MatrixJep, MRPEval Speed comparison");
        System.out.println("Number of iterations: " + num_itts);
        long t1 = System.currentTimeMillis();
        MRpSpeed.initVec();
        long t2 = System.currentTimeMillis();
        System.out.println("Vec initialise " + (t2 - t1));
        MRpSpeed.initMat();
        long t3 = System.currentTimeMillis();
        System.out.println("Mat initialise " + (t3 - t2));
        MRpSpeed.doRawAdd();
        MRpSpeed.doObjAdd();
        MRpSpeed.doRawMult();
        MRpSpeed.doObjMult();
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*y");
        MRpSpeed.doAll(new String[0], "y=[[1,2,3],[4,5,6],[7,8,9]]");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "z=y*y");
        MRpSpeed.doAll(new String[0], "[[1,2,3],[4,5,6],[7,8,9]]*[[1,2,3],[4,5,6],[7,8,9]]");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y+y");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y-y");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*y+y");
        MRpSpeed.doAll(new String[]{"x=[1,2,3]", "y=[[1,2,3],[4,5,6],[7,8,9]]"}, "x*y");
        MRpSpeed.doAll(new String[]{"x=[1,2,3]", "y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*x");
        MRpSpeed.doAll(new String[]{"y=[1,2,3]"}, "y+y");
        MRpSpeed.doAll(new String[]{"y=[1,2,3]"}, "y . y");
        MRpSpeed.doAll(new String[]{"y=[1,2,3]"}, "y^^y");
        MRpSpeed.doAll(new String[]{"y=[[1,2],[3,4]]"}, "y*y");
        MRpSpeed.doAll(new String[]{"y=[[1,2],[3,4]]"}, "y+y");
        MRpSpeed.doAll(new String[]{"y=[[1,2],[3,4]]"}, "y-y");
        MRpSpeed.doAll(new String[]{"y=[[1,2],[3,4]]"}, "y*y+y");
        MRpSpeed.doAll(new String[]{"x=[1,2]", "y=[[1,2],[3,4]]"}, "x*y");
        MRpSpeed.doAll(new String[]{"x=[1,2]", "y=[[1,2],[3,4]]"}, "y*x");
        MRpSpeed.doAll(new String[0], "1*2*3+4*5*6+7*8*9");
        MRpSpeed.doAll(new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9"}, "x1*x2*x3+x4*x5*x6+x7*x8*x9");
        MRpSpeed.doAll(new String[]{"y=[1,2,3,4,5]"}, "y+y");
        MRpSpeed.doAll(new String[]{"y=[[1,2,3,4,5],[6,7,8,9,10],[11,12,13,14,15],[16,17,18,19,20],[21,22,23,24,25]]"}, "y*y");
        MRpSpeed.doAll(new String[]{"x=0.7"}, "cos(x)^2+sin(x)^2");
        int scale = 2;
        while (scale <= 6) {
            StringBuffer sb = new StringBuffer("y=[");
            int k = 1;
            int i = 0;
            while (i < scale) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('[');
                int j = 0;
                while (j < scale) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append(k);
                    ++k;
                    ++j;
                }
                sb.append(']');
                ++i;
            }
            sb.append(']');
            MRpSpeed.doAll(new String[]{sb.toString()}, "y*y");
            ++scale;
        }
    }

    public static void doAll(String[] eqns, String eqn2) {
        System.out.println("\nTesting speed for <" + eqn2 + "> Where ");
        int i = 0;
        while (i < eqns.length) {
            System.out.println("\t" + eqns[i]);
            ++i;
        }
        long v = MRpSpeed.doVec(eqns, eqn2);
        long m = MRpSpeed.doMat(eqns, eqn2);
        long r = MRpSpeed.doRpe(eqns, eqn2);
        if (m != 0L && r != 0L) {
            System.out.println("v/m " + v / m + " v/r " + v / r + " m/r " + m / r);
        }
    }

    static void initVec() {
        vj = new VectorJep();
        vj.addStandardConstants();
        vj.addStandardFunctions();
        vj.addComplex();
        vj.setAllowUndeclared(true);
        vj.setImplicitMul(true);
        vj.setAllowAssignment(true);
    }

    static long doVec(String[] eqns, String eqn2) {
        try {
            int i = 0;
            while (i < eqns.length) {
                Node node2 = vj.parse(eqns[i]);
                vj.evaluate(node2);
                ++i;
            }
            Node node = vj.parse(eqn2);
            long t1 = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < num_itts) {
                vj.evaluate(node);
                ++i2;
            }
            long t2 = System.currentTimeMillis();
            Object res = vj.evaluate(node);
            System.out.print("Using VectorJep:\t" + (t2 - t1));
            System.out.println("\t" + res.toString());
            return t2 - t1;
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
            return 0L;
        }
    }

    static void initMat() {
        mj = new MatrixJep();
        mj.addStandardConstants();
        mj.addStandardFunctions();
        mj.addComplex();
        mj.setAllowUndeclared(true);
        mj.setImplicitMul(true);
        mj.setAllowAssignment(true);
    }

    static long doMat(String[] eqns, String eqn2) {
        try {
            int i = 0;
            while (i < eqns.length) {
                Node node2 = mj.simplify(mj.preprocess(mj.parse(eqns[i])));
                mj.evaluate(node2);
                ++i;
            }
            Node node3 = mj.simplify(mj.preprocess(mj.parse(eqn2)));
            long t1 = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < num_itts) {
                mj.evaluateRaw(node3);
                ++i2;
            }
            long t2 = System.currentTimeMillis();
            System.out.print("Using MatrixJep:\t" + (t2 - t1));
            Object res = mj.evaluate(node3);
            System.out.println("\t" + res.toString());
            return t2 - t1;
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
            return 0L;
        }
    }

    static long doRpe(String[] eqns, String eqn2) {
        try {
            int i = 0;
            while (i < eqns.length) {
                Node node2 = mj.simplify(mj.preprocess(mj.parse(eqns[i])));
                mj.evaluate(node2);
                ++i;
            }
            Node node3 = mj.simplify(mj.preprocess(mj.parse(eqn2)));
            MRpEval rpe = new MRpEval(mj);
            MRpCommandList list = rpe.compile(node3);
            long t1 = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < num_itts) {
                rpe.evaluate(list);
                ++i2;
            }
            long t2 = System.currentTimeMillis();
            System.out.print("Using MRpEval:\t\t" + (t2 - t1));
            MRpRes res = rpe.evaluate(list);
            System.out.println("\t" + res.toString());
            rpe.cleanUp();
            return t2 - t1;
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
            e.printStackTrace();
            return 0L;
        }
    }

    static void doRawAdd() {
        double[][] mat1 = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        double[][] mat2 = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        double[][] mat3 = new double[3][3];
        long t1 = System.currentTimeMillis();
        int i = 0;
        while (i < num_itts) {
            int row = 0;
            while (row < 3) {
                int col = 0;
                while (col < 3) {
                    mat3[row][col] = mat1[row][col] + mat2[row][col];
                    ++col;
                }
                ++row;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        System.out.println("RawAdd:" + (t2 - t1) + "\tTime to add two double[3][3] arrays");
    }

    static void doRawMult() {
        double[][] mat1 = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        double[][] mat2 = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        double[][] mat3 = new double[3][3];
        long t1 = System.currentTimeMillis();
        int i = 0;
        while (i < num_itts) {
            int row = 0;
            while (row < 3) {
                int col = 0;
                while (col < 3) {
                    mat3[row][col] = mat1[row][0] * mat2[0][col];
                    int j = 1;
                    while (j < 3) {
                        double[] dArray = mat3[row];
                        int n = col;
                        dArray[n] = dArray[n] + mat1[row][j] * mat2[j][col];
                        ++j;
                    }
                    ++col;
                }
                ++row;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        System.out.println("RawMult:" + (t2 - t1) + "\tTime to multiply two double[3][3] arrays");
    }

    static void doObjAdd() {
        Double[][] mat1 = new Double[][]{{new Double(1.0), new Double(2.0), new Double(3.0)}, {new Double(4.0), new Double(5.0), new Double(6.0)}, {new Double(7.0), new Double(8.0), new Double(9.0)}};
        Double[][] mat2 = new Double[][]{{new Double(1.0), new Double(2.0), new Double(3.0)}, {new Double(4.0), new Double(5.0), new Double(6.0)}, {new Double(7.0), new Double(8.0), new Double(9.0)}};
        Double[][] mat3 = new Double[3][3];
        long t1 = System.currentTimeMillis();
        int i = 0;
        while (i < num_itts) {
            int row = 0;
            while (row < 3) {
                int col = 0;
                while (col < 3) {
                    mat3[row][col] = new Double(mat1[row][col] + mat2[row][col]);
                    ++col;
                }
                ++row;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        System.out.println("ObjAdd:" + (t2 - t1) + "\tTime to add two Double[3][3] arrays");
    }

    static void doObjMult() {
        Double[][] mat1 = new Double[][]{{new Double(1.0), new Double(2.0), new Double(3.0)}, {new Double(4.0), new Double(5.0), new Double(6.0)}, {new Double(7.0), new Double(8.0), new Double(9.0)}};
        Double[][] mat2 = new Double[][]{{new Double(1.0), new Double(2.0), new Double(3.0)}, {new Double(4.0), new Double(5.0), new Double(6.0)}, {new Double(7.0), new Double(8.0), new Double(9.0)}};
        Double[][] mat3 = new Double[3][3];
        long t1 = System.currentTimeMillis();
        int i = 0;
        while (i < num_itts) {
            int row = 0;
            while (row < 3) {
                int col = 0;
                while (col < 3) {
                    double tmp = mat1[row][0] * mat2[0][col];
                    int j = 1;
                    while (j < 3) {
                        tmp += mat1[row][j] * mat2[j][col];
                        ++j;
                    }
                    mat3[row][col] = new Double(tmp);
                    ++col;
                }
                ++row;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        System.out.println("ObjMult:" + (t2 - t1) + "\tTime to multiply two Double[3][3] arrays");
    }
}

