/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.lsmp.djep.djep.DJep;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DJepApplet
extends Applet
implements ActionListener {
    private static final long serialVersionUID = -2026659445630529741L;
    DJep j;
    TextField inputTF;
    TextField varTF;
    TextField outputTF;
    Button but;

    public void init() {
        this.initialise();
        this.setLayout(new GridLayout(3, 2));
        this.inputTF = new TextField("sin(x^2)", 50);
        this.outputTF = new TextField(50);
        this.outputTF.setEditable(false);
        this.varTF = new TextField("x", 5);
        this.but = new Button("Calculate");
        this.but.addActionListener(this);
        this.inputTF.addActionListener(this);
        Panel p1 = new Panel();
        p1.add(new Label("Differentiate:"));
        p1.add(this.inputTF);
        this.add(p1);
        Panel p2 = new Panel();
        p2.add(new Label("with respect to:"));
        p2.add(this.varTF);
        p2.add(this.but);
        this.add(p2);
        Panel p3 = new Panel();
        p3.add(new Label("Result:"));
        p3.add(this.outputTF);
        this.add(p3);
    }

    public void actionPerformed(ActionEvent e) {
        String command = this.inputTF.getText();
        this.j.parseExpression(command);
        if (this.j.hasError()) {
            this.outputTF.setText(this.j.getErrorInfo());
        } else {
            try {
                Node diff = this.j.differentiate(this.j.getTopNode(), this.varTF.getText());
                Node simp = this.j.simplify(diff);
                if (this.j.hasError()) {
                    this.outputTF.setText(this.j.getErrorInfo());
                } else {
                    this.outputTF.setText(this.j.toString(simp));
                }
            }
            catch (ParseException e1) {
                this.outputTF.setText("Parse Error: " + e1.getMessage());
            }
            catch (IllegalArgumentException e2) {
                this.outputTF.setText(e2.getMessage());
            }
            catch (Exception e3) {
                this.outputTF.setText(e3.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        DJepApplet app = new DJepApplet();
        app.init();
        Frame mainFrame = new Frame("Wallpaper patterns");
        mainFrame.setBounds(0, 0, 200, 200);
        mainFrame.add(app);
        mainFrame.show();
    }

    public void initialise() {
        this.j = new DJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setAllowAssignment(true);
        this.j.setImplicitMul(true);
        this.j.addStandardDiffRules();
    }
}

