/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommandI;

public class NodeFactory {
    protected XJep xj;

    public NodeFactory(XJep xj) {
        this.xj = xj;
    }

    private NodeFactory() {
    }

    public void copyChildren(Node node, Node[] children) {
        int nchild = children.length;
        node.jjtOpen();
        int i = 0;
        while (i < nchild) {
            children[i].jjtSetParent(node);
            node.jjtAddChild(children[i], i);
            ++i;
        }
        node.jjtClose();
    }

    public ASTConstant buildConstantNode(Object value) throws ParseException {
        ASTConstant node = new ASTConstant(4);
        node.setValue(value);
        return node;
    }

    public ASTConstant buildConstantNode(ASTConstant node) throws ParseException {
        return this.buildConstantNode(node.getValue());
    }

    public ASTConstant buildConstantNode(PostfixMathCommandI pfmc, Node[] children) throws IllegalArgumentException, ParseException {
        ASTFunNode node2 = this.buildFunctionNode("tmpfun", pfmc, children);
        Object val = this.xj.getEvaluatorVisitor().eval(node2);
        return this.buildConstantNode(val);
    }

    public ASTConstant buildConstantNode(Operator op, Node[] children) throws IllegalArgumentException, ParseException {
        return this.buildConstantNode(op.getPFMC(), children);
    }

    public ASTConstant buildConstantNode(Operator op, Node child1, Node child2) throws IllegalArgumentException, ParseException {
        return this.buildConstantNode(op.getPFMC(), new Node[]{child1, child2});
    }

    public ASTConstant buildConstantNode(Operator op, Node child1) throws IllegalArgumentException, ParseException {
        return this.buildConstantNode(op.getPFMC(), new Node[]{child1});
    }

    public ASTVarNode buildVariableNode(ASTVarNode node) throws ParseException {
        return this.buildVariableNode(node.getVar());
    }

    public ASTVarNode buildVariableNode(Variable var) throws ParseException {
        ASTVarNode node = new ASTVarNode(3);
        node.setVar(var);
        return node;
    }

    public ASTVarNode buildVariableNode(String name, Object value) throws ParseException {
        return this.buildVariableNode(this.xj.getSymbolTable().addVariable(name, value));
    }

    public ASTFunNode buildOperatorNode(Operator op, Node[] arguments) throws ParseException {
        ASTFunNode res = new ASTFunNode(2);
        res.setOperator(op);
        this.copyChildren(res, arguments);
        return res;
    }

    public ASTFunNode buildFunctionNode(String name, PostfixMathCommandI pfmc, Node[] arguments) throws ParseException {
        ASTFunNode res = new ASTFunNode(2);
        res.setFunction(name, pfmc);
        this.copyChildren(res, arguments);
        return res;
    }

    public ASTFunNode buildUnfinishedOperatorNode(Operator op) {
        ASTFunNode res = new ASTFunNode(2);
        res.setOperator(op);
        return res;
    }

    public ASTFunNode buildOperatorNode(Operator op, Node child) throws ParseException {
        return this.buildOperatorNode(op, new Node[]{child});
    }

    public ASTFunNode buildOperatorNode(Operator op, Node lhs, Node rhs) throws ParseException {
        return this.buildOperatorNode(op, new Node[]{lhs, rhs});
    }

    public ASTFunNode buildFunctionNode(ASTFunNode node, Node[] arguments) throws ParseException {
        if (node.getOperator() != null) {
            return this.buildOperatorNode(node.getOperator(), arguments);
        }
        return this.buildFunctionNode(node.getName(), node.getPFMC(), arguments);
    }
}

