/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.values;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MatrixValueI;

public class Matrix
implements MatrixValueI {
    int rows = 0;
    int cols = 0;
    Object[][] data = null;
    Dimensions dims;

    public MatrixValueI copy() {
        Matrix tmp = new Matrix(this.rows, this.cols);
        tmp.setEles(this);
        return tmp;
    }

    private Matrix() {
    }

    protected Matrix(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.data = new Object[rows][cols];
        this.dims = Dimensions.valueOf(rows, cols);
    }

    public static MatrixValueI getInstance(int rows, int cols) {
        return new Matrix(rows, cols);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int i = 0;
        while (i < this.rows) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('[');
            int j = 0;
            while (j < this.cols) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(this.data[i][j]);
                ++j;
            }
            sb.append(']');
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public Dimensions getDim() {
        return this.dims;
    }

    public int getNumEles() {
        return this.rows * this.cols;
    }

    public int getNumRows() {
        return this.rows;
    }

    public int getNumCols() {
        return this.cols;
    }

    public void setEle(int n, Object value) {
        int i = n / this.cols;
        int j = n % this.cols;
        this.data[i][j] = value;
    }

    public void setEle(int i, int j, Object value) {
        this.data[i][j] = value;
    }

    public Object getEle(int n) {
        int i = n / this.cols;
        int j = n % this.cols;
        return this.data[i][j];
    }

    public Object getEle(int i, int j) {
        return this.data[i][j];
    }

    public Object[][] getEles() {
        return this.data;
    }

    public void setEles(MatrixValueI val) {
        if (!this.dims.equals(val.getDim())) {
            return;
        }
        int i = 0;
        while (i < this.rows) {
            System.arraycopy(((Matrix)val).data[i], 0, this.data[i], 0, this.cols);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        Matrix mat = (Matrix)obj;
        if (!mat.getDim().equals(this.getDim())) {
            return false;
        }
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (!this.data[i][j].equals(mat.data[i][j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                result = 37 * result + this.data[i][j].hashCode();
                ++j;
            }
            ++i;
        }
        return result;
    }
}

