/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import java.util.Vector;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.List;

public class VList
extends List
implements NaryOperatorI {
    public VList() {
        this.numberOfParameters = -1;
    }

    public Dimensions calcDim(Dimensions[] dims) throws ParseException {
        return Dimensions.valueOf(dims.length, dims[0]);
    }

    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI[] inputs) throws ParseException {
        int eleSize = inputs[0].getNumEles();
        int i = 0;
        while (i < inputs.length) {
            int j = 0;
            while (j < eleSize) {
                res.setEle(i * eleSize + j, inputs[i].getEle(j));
                ++j;
            }
            ++i;
        }
        return res;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        if (this.curNumberOfParameters < 1) {
            throw new ParseException("Empty list");
        }
        Object param1 = inStack.pop();
        if (param1 instanceof Vector) {
            Vector vec1 = (Vector)param1;
            int rows = this.curNumberOfParameters;
            int cols = vec1.size();
            Matrix res = (Matrix)Matrix.getInstance(rows, cols);
            int j = 0;
            while (j < cols) {
                res.setEle(rows - 1, j, vec1.elementAt(j));
                ++j;
            }
            int i = rows - 2;
            while (i >= 0) {
                Vector vec = (Vector)inStack.pop();
                int j2 = 0;
                while (j2 < cols) {
                    res.setEle(i, j2, vec.elementAt(j2));
                    ++j2;
                }
                --i;
            }
            inStack.push(res);
            return;
        }
        if (param1 instanceof MatrixValueI) {
            MatrixValueI mat1 = (MatrixValueI)param1;
            int rows = this.curNumberOfParameters;
            int neles = mat1.getNumEles();
            MatrixValueI res = Tensor.getInstance(Dimensions.valueOf(rows, mat1.getDim()));
            int j = 0;
            while (j < neles) {
                res.setEle((rows - 1) * neles + j, mat1.getEle(j));
                ++j;
            }
            int i = rows - 2;
            while (i >= 0) {
                MatrixValueI mat = (MatrixValueI)inStack.pop();
                int j3 = 0;
                while (j3 < neles) {
                    res.setEle(i * neles + j3, mat.getEle(j3));
                    ++j3;
                }
                --i;
            }
            inStack.push(res);
            return;
        }
        MVector res = new MVector(this.curNumberOfParameters);
        res.setEle(this.curNumberOfParameters - 1, param1);
        int i = this.curNumberOfParameters - 2;
        while (i >= 0) {
            Object param = inStack.pop();
            res.setEle(i, param);
            --i;
        }
        inStack.push(res);
    }
}

