/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommandI;

public class PFunction
extends AbstractPNode {
    String name;
    PostfixMathCommandI pfmc;
    PNodeI[] args;

    public PFunction(PolynomialCreator pc, String name, PostfixMathCommandI pfmc, PNodeI[] args) {
        super(pc);
        this.name = name;
        this.pfmc = pfmc;
        this.args = args;
    }

    public boolean equals(PNodeI node) {
        if (!(node instanceof PFunction)) {
            return false;
        }
        PFunction fun = (PFunction)node;
        if (!this.name.equals(fun.name)) {
            return false;
        }
        if (this.args.length != fun.args.length) {
            return false;
        }
        int i = 0;
        while (i < this.args.length) {
            if (!this.args[i].equals(fun.args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int compareTo(PFunction fun) {
        int res = this.name.compareTo(fun.name);
        if (res != 0) {
            return res;
        }
        if (this.args.length < fun.args.length) {
            return -1;
        }
        if (this.args.length > fun.args.length) {
            return 1;
        }
        int i = 0;
        while (i < this.args.length) {
            res = this.args[i].compareTo(fun.args[i]);
            if (res != 0) {
                return res;
            }
            ++i;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append('(');
        int i = 0;
        while (i < this.args.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.args[i].toString());
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    public Node toNode() throws ParseException {
        Node[] funargs = new Node[this.args.length];
        int i = 0;
        while (i < this.args.length) {
            funargs[i] = this.args[i].toNode();
            ++i;
        }
        ASTFunNode fun = this.pc.nf.buildFunctionNode(this.name, this.pfmc, funargs);
        return fun;
    }

    public PNodeI expand() throws ParseException {
        PNodeI[] newTerms = new PNodeI[this.args.length];
        int i = 0;
        while (i < this.args.length) {
            newTerms[i] = this.args[i].expand();
            ++i;
        }
        return new PFunction(this.pc, this.name, this.pfmc, newTerms);
    }

    public String getName() {
        return this.name;
    }

    public PostfixMathCommandI getPfmc() {
        return this.pfmc;
    }

    public int getNArgs() {
        return this.args.length;
    }

    public PNodeI getArg(int i) {
        return this.args[i];
    }
}

