/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.ParseException;

public class MutiableMonomial {
    PolynomialCreator pc;
    PConstant coeff;
    int length;
    PNodeI[] terms;
    PNodeI[] powers;

    public MutiableMonomial(PolynomialCreator pc, PConstant coeff, PNodeI[] nodes, PNodeI[] pows) {
        this.pc = pc;
        this.coeff = coeff;
        this.length = nodes.length;
        this.terms = nodes;
        this.powers = pows;
    }

    public void mul(PConstant c) throws ParseException {
        this.coeff = (PConstant)this.coeff.mul(c);
    }

    public void div(PConstant c) throws ParseException {
        this.coeff = (PConstant)this.coeff.div(c);
    }

    public void mul(PNodeI term, PNodeI power) throws ParseException {
        int i = 0;
        while (i < this.length) {
            if (this.terms[i].equals(term)) {
                this.powers[i] = this.powers[i].add(power);
                return;
            }
            ++i;
        }
        PNodeI[] newTerms = new PNodeI[this.length + 1];
        PNodeI[] newPowers = new PNodeI[this.length + 1];
        int pos = 0;
        boolean done = false;
        int i2 = 0;
        while (i2 < this.length) {
            if (!done && this.terms[i2].compareTo(term) > 0) {
                newTerms[pos] = term;
                newPowers[pos] = power;
                ++pos;
                done = true;
            }
            newTerms[pos] = this.terms[i2];
            newPowers[pos] = this.powers[i2];
            ++pos;
            ++i2;
        }
        if (!done) {
            newTerms[pos] = term;
            newPowers[pos] = power;
            ++pos;
        }
        ++this.length;
        this.terms = newTerms;
        this.powers = newPowers;
    }

    void power(PConstant c) throws ParseException {
        this.coeff = (PConstant)this.coeff.pow(c);
        int i = 0;
        while (i < this.length) {
            this.powers[i] = this.powers[i].mul(c);
            ++i;
        }
    }

    private void reduce() throws ParseException {
        int numZeros = 0;
        int numOnes = 0;
        int numConst = 0;
        int i = 0;
        while (i < this.length) {
            if (this.powers[i].isZero()) {
                ++numZeros;
            } else if (this.terms[i].isOne()) {
                ++numOnes;
            } else if (this.terms[i] instanceof PConstant && this.powers[i] instanceof PConstant) {
                ++numConst;
            }
            ++i;
        }
        if (numZeros == 0 && numOnes == 0 && numConst == 0) {
            return;
        }
        int newLen = this.length - numZeros - numOnes - numConst;
        PNodeI[] newTerms = new PNodeI[newLen];
        PNodeI[] newPowers = new PNodeI[newLen];
        int pos = 0;
        int i2 = 0;
        while (i2 < this.length) {
            if (!this.powers[i2].isZero() && !this.terms[i2].isOne()) {
                if (this.terms[i2] instanceof PConstant && this.powers[i2] instanceof PConstant) {
                    this.coeff = (PConstant)this.coeff.mul(this.terms[i2].pow(this.powers[i2]));
                } else {
                    newTerms[pos] = this.terms[i2];
                    newPowers[pos] = this.powers[i2];
                    ++pos;
                }
            }
            ++i2;
        }
        this.length = newLen;
        this.terms = newTerms;
        this.powers = newPowers;
    }

    PNodeI toPNode() throws ParseException {
        this.reduce();
        if (this.length == 0) {
            return this.coeff;
        }
        if (this.coeff.isZero()) {
            return this.pc.zeroConstant;
        }
        return new Monomial(this.pc, this.coeff, this.terms, this.powers);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.coeff.toString());
        int i = 0;
        while (i < this.length) {
            sb.append(this.terms[i]);
            sb.append('^');
            sb.append(this.powers[i]);
            ++i;
        }
        return sb.toString();
    }
}

