/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.rewrite;

import org.lsmp.djep.rewrite.RewriteRuleI;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.TreeUtils;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XMath;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;

public class ExpandPower
implements RewriteRuleI {
    private NodeFactory nf;
    private OperatorSet opSet;
    private TreeUtils tu;
    private XJep xj;

    public ExpandPower(XJep xj) {
        this.opSet = xj.getOperatorSet();
        this.tu = xj.getTreeUtils();
        this.nf = xj.getNodeFactory();
        this.xj = xj;
    }

    private ExpandPower() {
    }

    public boolean test(ASTFunNode node, Node[] children) {
        if (!node.isOperator()) {
            return false;
        }
        XOperator op = (XOperator)node.getOperator();
        if (this.opSet.getPower() == op) {
            if (this.tu.getOperator(children[0]) == this.opSet.getAdd() || this.tu.getOperator(children[0]) == this.opSet.getSubtract()) {
                return this.tu.isInteger(children[1]) && (this.tu.isPositive(children[1]) || this.tu.isZero(children[1]));
            }
            return false;
        }
        return false;
    }

    public Node apply(ASTFunNode node, Node[] children) throws ParseException {
        Operator lhsOp = this.tu.getOperator(children[0]);
        int n = this.tu.intValue(children[1]);
        Node sub1 = children[0].jjtGetChild(0);
        Node sub2 = children[0].jjtGetChild(1);
        if (lhsOp == this.opSet.getAdd() || lhsOp == this.opSet.getSubtract()) {
            if (n == 0) {
                return this.nf.buildConstantNode(new Double(1.0));
            }
            if (n == 1) {
                return children[0];
            }
            Node[] vals = new Node[n + 1];
            vals[0] = this.nf.buildOperatorNode(this.opSet.getPower(), this.xj.deepCopy(sub1), this.nf.buildConstantNode(new Double(n)));
            vals[1] = n == 2 ? this.nf.buildOperatorNode(this.opSet.getMultiply(), this.nf.buildConstantNode(new Double(2.0)), this.nf.buildOperatorNode(this.opSet.getMultiply(), this.xj.deepCopy(sub1), this.xj.deepCopy(sub2))) : this.nf.buildOperatorNode(this.opSet.getMultiply(), this.nf.buildConstantNode(new Double(n)), this.nf.buildOperatorNode(this.opSet.getMultiply(), this.nf.buildOperatorNode(this.opSet.getPower(), this.xj.deepCopy(sub1), this.nf.buildConstantNode(new Double(n - 1))), this.xj.deepCopy(sub2)));
            if (n >= 3) {
                vals[n - 1] = this.nf.buildOperatorNode(this.opSet.getMultiply(), this.nf.buildConstantNode(new Double(n)), this.nf.buildOperatorNode(this.opSet.getMultiply(), this.xj.deepCopy(sub1), this.nf.buildOperatorNode(this.opSet.getPower(), this.xj.deepCopy(sub2), this.nf.buildConstantNode(new Double(n - 1)))));
            }
            vals[n] = this.nf.buildOperatorNode(this.opSet.getPower(), this.xj.deepCopy(sub2), this.nf.buildConstantNode(new Double(n)));
            int i = 2;
            while (i < n - 1) {
                vals[i] = this.nf.buildOperatorNode(this.opSet.getMultiply(), this.nf.buildConstantNode(new Double(XMath.binomial(n, i))), this.nf.buildOperatorNode(this.opSet.getMultiply(), this.nf.buildOperatorNode(this.opSet.getPower(), this.xj.deepCopy(sub1), this.nf.buildConstantNode(new Double(n - i))), this.nf.buildOperatorNode(this.opSet.getPower(), this.xj.deepCopy(sub2), this.nf.buildConstantNode(new Double(i)))));
                ++i;
            }
            Node[] sums = new Node[n + 1];
            sums[n] = vals[n];
            int i2 = n - 1;
            while (i2 >= 0) {
                sums[i2] = this.nf.buildOperatorNode(lhsOp, vals[i2], sums[i2 + 1]);
                --i2;
            }
            return sums[0];
        }
        throw new ParseException("ExpandBrackets at least one child must be + or -");
    }
}

