/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.matrixJep;

import java.util.Enumeration;
import org.lsmp.djep.djep.DVariable;
import org.lsmp.djep.djep.PartialDerivative;
import org.lsmp.djep.matrixJep.MatrixPartialDerivative;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.lsmp.djep.xjep.PrintVisitor;
import org.nfunk.jep.Node;

public class MatrixVariable
extends DVariable
implements MatrixVariableI {
    private Dimensions dims;
    private MatrixValueI mvalue = null;

    protected PartialDerivative createDerivative(String[] derivnames, Node eqn) {
        return new MatrixPartialDerivative(this, derivnames, eqn);
    }

    MatrixVariable(String name) {
        super(name);
        this.dims = Dimensions.ONE;
        this.mvalue = Scaler.getInstance(new Double(0.0));
        this.setValidValue(false);
    }

    MatrixVariable(String name, Object value) {
        super(name);
        this.mvalue = value == null ? Scaler.getInstance(new Double(0.0)) : (value instanceof MatrixValueI ? (MatrixValueI)value : Scaler.getInstance(value));
        this.dims = this.mvalue.getDim();
        this.setValidValue(true);
    }

    public Dimensions getDimensions() {
        return this.dims;
    }

    public void setDimensions(Dimensions dims) {
        this.dims = dims;
        this.mvalue = Tensor.getInstance(dims);
        this.invalidateAll();
    }

    public MatrixValueI getMValue() {
        return this.mvalue;
    }

    public Object getValue() {
        if (this.mvalue instanceof Scaler) {
            return this.mvalue.getEle(0);
        }
        return this.mvalue;
    }

    protected boolean setValueRaw(Object val) {
        if (val instanceof MatrixValueI) {
            this.mvalue = (MatrixValueI)val;
            this.dims = this.mvalue.getDim();
        } else {
            this.mvalue.setEle(0, val);
        }
        this.setValidValue(true);
        return true;
    }

    public void setMValue(MatrixValueI val) {
        if (this.isConstant()) {
            return;
        }
        this.mvalue.setEles(val);
        this.setValidValue(true);
        this.setChanged();
        this.notifyObservers(val);
    }

    public void print(PrintVisitor bpv) {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append(": ");
        if (this.dims != null) {
            sb.append("dim " + this.dims.toString());
        }
        if (this.hasValidValue() && this.mvalue != null) {
            sb.append(" val " + this.getMValue());
        } else {
            sb.append(" null value");
        }
        sb.append(" ");
        if (this.getEquation() != null) {
            sb.append("eqn " + bpv.toString(this.getEquation()));
        } else {
            sb.append("no equation");
        }
        sb.append("\n");
        Enumeration e = this.derivatives.elements();
        while (e.hasMoreElements()) {
            MatrixPartialDerivative var = (MatrixPartialDerivative)e.nextElement();
            sb.append("\t" + var.toString() + ": ");
            if (var.hasValidValue()) {
                sb.append(" val " + var.getMValue());
            } else {
                sb.append(" null value");
            }
            sb.append(" ");
            sb.append(bpv.toString(var.getEquation()));
            sb.append("\n");
        }
        System.out.print(sb.toString());
    }
}

