/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.jama;

import Jama.Matrix;
import java.util.Stack;
import org.lsmp.djep.jama.JamaUtil;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Inverse
extends PostfixMathCommand
implements UnaryOperatorI {
    public Inverse() {
        this.numberOfParameters = 1;
    }

    public void run(Stack s) throws ParseException {
        Object o = s.pop();
        if (!(o instanceof org.lsmp.djep.vectorJep.values.Matrix)) {
            throw new ParseException("inverse: can only be applied to a matrix");
        }
        Matrix m = JamaUtil.toJama((org.lsmp.djep.vectorJep.values.Matrix)o);
        Matrix inv = m.inverse();
        org.lsmp.djep.vectorJep.values.Matrix res = JamaUtil.fromJama(inv);
        s.push(res);
    }

    public Dimensions calcDim(Dimensions ldim) {
        int cols;
        int rows = ldim.getFirstDim();
        if (rows < (cols = ldim.getLastDim())) {
            return Dimensions.valueOf(rows, rows);
        }
        if (rows > cols) {
            return Dimensions.valueOf(cols, cols);
        }
        return ldim;
    }

    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI lhs) throws ParseException {
        if (!(lhs instanceof org.lsmp.djep.vectorJep.values.Matrix)) {
            throw new ParseException("inverse: can only be applied to a matrix");
        }
        if (!(res instanceof org.lsmp.djep.vectorJep.values.Matrix)) {
            throw new ParseException("inverse: result should be a matrix");
        }
        Matrix m = JamaUtil.toJama((org.lsmp.djep.vectorJep.values.Matrix)lhs);
        Matrix inv = m.inverse();
        JamaUtil.fromJama(inv, (org.lsmp.djep.vectorJep.values.Matrix)res);
        return res;
    }
}

