/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.util.Checks;

public class DefaultDependencyDescriptor
implements DependencyDescriptor {
    private static final Pattern SELF_FALLBACK_PATTERN = Pattern.compile("@(\\(.*\\))?");
    private static final Pattern THIS_FALLBACK_PATTERN = Pattern.compile("#(\\(.*\\))?");
    private final ModuleRevisionId revId;
    private ModuleRevisionId dynamicRevId;
    private Map confs = new LinkedHashMap();
    private Map dependencyArtifacts;
    private Map includeRules;
    private Map excludeRules;
    private boolean isForce;
    private boolean isChanging;
    private ModuleRevisionId parentId;
    private boolean isTransitive = true;
    private Namespace namespace = null;
    private final ModuleDescriptor md;
    private DependencyDescriptor asSystem = this;

    public static DependencyDescriptor transformInstance(DependencyDescriptor dd, Namespace ns) {
        NamespaceTransformer t = ns.getToSystemTransformer();
        if (t.isIdentity()) {
            return dd;
        }
        DefaultDependencyDescriptor newdd = DefaultDependencyDescriptor.transformInstance(dd, t, false);
        newdd.namespace = ns;
        return newdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultDependencyDescriptor transformInstance(DependencyDescriptor dd, NamespaceTransformer t, boolean fromSystem) {
        ModuleRevisionId transformParentId = t.transform(dd.getParentRevisionId());
        ModuleRevisionId transformMrid = t.transform(dd.getDependencyRevisionId());
        ModuleRevisionId transformDynamicMrid = t.transform(dd.getDynamicConstraintDependencyRevisionId());
        DefaultDependencyDescriptor newdd = new DefaultDependencyDescriptor(null, transformMrid, transformDynamicMrid, dd.isForce(), dd.isChanging(), dd.isTransitive());
        newdd.parentId = transformParentId;
        String[] moduleConfs = dd.getModuleConfigurations();
        if (moduleConfs.length == 1 && "*".equals(moduleConfs[0])) {
            if (!(dd instanceof DefaultDependencyDescriptor)) throw new IllegalArgumentException("dependency descriptor transformation does not support * module confs with descriptors which aren't DefaultDependencyDescriptor");
            DefaultDependencyDescriptor ddd = (DefaultDependencyDescriptor)dd;
            newdd.confs = new LinkedHashMap(ddd.confs);
            newdd.setExcludeRules(new LinkedHashMap(ddd.getExcludeRules()));
            newdd.setIncludeRules(new LinkedHashMap(ddd.getIncludeRules()));
            newdd.setDependencyArtifacts(new LinkedHashMap(ddd.getDependencyArtifacts()));
        } else {
            for (int i = 0; i < moduleConfs.length; ++i) {
                newdd.confs.put(moduleConfs[i], new ArrayList<String>(Arrays.asList(dd.getDependencyConfigurations(moduleConfs[i]))));
                newdd.getExcludeRules().put(moduleConfs[i], new ArrayList<ExcludeRule>(Arrays.asList(dd.getExcludeRules(moduleConfs[i]))));
                newdd.getIncludeRules().put(moduleConfs[i], new ArrayList<IncludeRule>(Arrays.asList(dd.getIncludeRules(moduleConfs[i]))));
                newdd.getDependencyArtifacts().put(moduleConfs[i], new ArrayList<DependencyArtifactDescriptor>(Arrays.asList(dd.getDependencyArtifacts(moduleConfs[i]))));
            }
        }
        if (!fromSystem) return newdd;
        newdd.asSystem = dd;
        return newdd;
    }

    private DefaultDependencyDescriptor(DefaultDependencyDescriptor dd, ModuleRevisionId revision) {
        Checks.checkNotNull(dd, "dd");
        Checks.checkNotNull(revision, "revision");
        if (!revision.getModuleId().equals(dd.getDependencyId())) {
            throw new IllegalArgumentException("new ModuleRevisionId MUST have the same ModuleId as original one. original = " + dd.getDependencyId() + " new = " + revision.getModuleId());
        }
        this.md = dd.md;
        this.parentId = dd.parentId;
        this.revId = revision;
        this.dynamicRevId = dd.dynamicRevId;
        this.isForce = dd.isForce;
        this.isChanging = dd.isChanging;
        this.isTransitive = dd.isTransitive;
        this.namespace = dd.namespace;
        this.confs.putAll(dd.confs);
        this.excludeRules = dd.excludeRules == null ? null : new LinkedHashMap(dd.excludeRules);
        this.includeRules = dd.includeRules == null ? null : new LinkedHashMap(dd.includeRules);
        this.dependencyArtifacts = dd.dependencyArtifacts == null ? null : new LinkedHashMap(dd.dependencyArtifacts);
    }

    public DefaultDependencyDescriptor(ModuleDescriptor md, ModuleRevisionId mrid, boolean force, boolean changing, boolean transitive) {
        this(md, mrid, mrid, force, changing, transitive);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId mrid, boolean force) {
        this(mrid, force, false);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId mrid, boolean force, boolean changing) {
        this(null, mrid, mrid, force, changing, true);
    }

    public DefaultDependencyDescriptor(ModuleDescriptor md, ModuleRevisionId mrid, ModuleRevisionId dynamicConstraint, boolean force, boolean changing, boolean transitive) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(dynamicConstraint, "dynamicConstraint");
        this.md = md;
        this.revId = mrid;
        this.dynamicRevId = dynamicConstraint;
        this.isForce = force;
        this.isChanging = changing;
        this.isTransitive = transitive;
    }

    public ModuleId getDependencyId() {
        return this.getDependencyRevisionId().getModuleId();
    }

    public ModuleRevisionId getDependencyRevisionId() {
        return this.revId;
    }

    public ModuleRevisionId getDynamicConstraintDependencyRevisionId() {
        return this.dynamicRevId;
    }

    public String[] getModuleConfigurations() {
        return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
    }

    public String[] getDependencyConfigurations(String moduleConfiguration) {
        return this.getDependencyConfigurations(moduleConfiguration, moduleConfiguration);
    }

    public String[] getDependencyConfigurations(String moduleConfiguration, String requestedConfiguration) {
        List confsList = (List)this.confs.get(moduleConfiguration);
        if (confsList == null) {
            confsList = (List)this.confs.get("%");
        }
        List defConfs = (List)this.confs.get("*");
        LinkedHashSet<Object> ret = new LinkedHashSet();
        if (confsList != null) {
            ret.addAll(confsList);
        }
        if (defConfs != null) {
            ret.addAll(defConfs);
        }
        LinkedHashSet<String> replacedRet = new LinkedHashSet<String>();
        Iterator iter = ret.iterator();
        while (iter.hasNext()) {
            String c = (String)iter.next();
            String replacedConf = DefaultDependencyDescriptor.replaceSelfFallbackPattern(c, moduleConfiguration);
            if (replacedConf == null) {
                replacedConf = DefaultDependencyDescriptor.replaceThisFallbackPattern(c, requestedConfiguration);
            }
            if (replacedConf != null) {
                c = replacedConf;
            }
            replacedRet.add(c);
        }
        ret = replacedRet;
        if (ret.remove("*")) {
            StringBuffer r = new StringBuffer("*");
            Iterator iter2 = ret.iterator();
            while (iter2.hasNext()) {
                String c = (String)iter2.next();
                if (!c.startsWith("!")) continue;
                r.append(c);
            }
            return new String[]{r.toString()};
        }
        return ret.toArray(new String[ret.size()]);
    }

    protected static String replaceSelfFallbackPattern(String conf, String moduleConfiguration) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(SELF_FALLBACK_PATTERN, conf, moduleConfiguration);
    }

    protected static String replaceThisFallbackPattern(String conf, String requestedConfiguration) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(THIS_FALLBACK_PATTERN, conf, requestedConfiguration);
    }

    protected static String replaceFallbackConfigurationPattern(Pattern pattern, String conf, String moduleConfiguration) {
        Matcher matcher = pattern.matcher(conf);
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                return moduleConfiguration + matcher.group(1);
            }
            return moduleConfiguration;
        }
        return null;
    }

    public String[] getDependencyConfigurations(String[] moduleConfigurations) {
        LinkedHashSet<String> confs = new LinkedHashSet<String>();
        for (int i = 0; i < moduleConfigurations.length; ++i) {
            confs.addAll(Arrays.asList(this.getDependencyConfigurations(moduleConfigurations[i])));
        }
        if (confs.contains("*")) {
            return new String[]{"*"};
        }
        return confs.toArray(new String[confs.size()]);
    }

    public DependencyArtifactDescriptor[] getDependencyArtifacts(String moduleConfiguration) {
        Set artifacts = this.getCollectionForConfiguration(moduleConfiguration, this.dependencyArtifacts);
        return artifacts.toArray(new DependencyArtifactDescriptor[artifacts.size()]);
    }

    public IncludeRule[] getIncludeRules(String moduleConfiguration) {
        Set rules = this.getCollectionForConfiguration(moduleConfiguration, this.includeRules);
        return rules.toArray(new IncludeRule[rules.size()]);
    }

    public ExcludeRule[] getExcludeRules(String moduleConfiguration) {
        Set rules = this.getCollectionForConfiguration(moduleConfiguration, this.excludeRules);
        return rules.toArray(new ExcludeRule[rules.size()]);
    }

    private Set getCollectionForConfiguration(String moduleConfiguration, Map collectionMap) {
        if (collectionMap == null || collectionMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Collection artifacts = (Collection)collectionMap.get(moduleConfiguration);
        Collection defArtifacts = (Collection)collectionMap.get("*");
        LinkedHashSet ret = new LinkedHashSet();
        if (artifacts != null) {
            ret.addAll(artifacts);
        }
        if (defArtifacts != null) {
            ret.addAll(defArtifacts);
        }
        return ret;
    }

    public DependencyArtifactDescriptor[] getDependencyArtifacts(String[] moduleConfigurations) {
        LinkedHashSet<DependencyArtifactDescriptor> artifacts = new LinkedHashSet<DependencyArtifactDescriptor>();
        for (int i = 0; i < moduleConfigurations.length; ++i) {
            artifacts.addAll(Arrays.asList(this.getDependencyArtifacts(moduleConfigurations[i])));
        }
        return artifacts.toArray(new DependencyArtifactDescriptor[artifacts.size()]);
    }

    public IncludeRule[] getIncludeRules(String[] moduleConfigurations) {
        LinkedHashSet<IncludeRule> rules = new LinkedHashSet<IncludeRule>();
        for (int i = 0; i < moduleConfigurations.length; ++i) {
            rules.addAll(Arrays.asList(this.getIncludeRules(moduleConfigurations[i])));
        }
        return rules.toArray(new IncludeRule[rules.size()]);
    }

    public ExcludeRule[] getExcludeRules(String[] moduleConfigurations) {
        LinkedHashSet<ExcludeRule> rules = new LinkedHashSet<ExcludeRule>();
        for (int i = 0; i < moduleConfigurations.length; ++i) {
            rules.addAll(Arrays.asList(this.getExcludeRules(moduleConfigurations[i])));
        }
        return rules.toArray(new ExcludeRule[rules.size()]);
    }

    public DependencyArtifactDescriptor[] getAllDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            return new DependencyArtifactDescriptor[0];
        }
        Set ret = this.mergeAll(this.dependencyArtifacts);
        return ret.toArray(new DependencyArtifactDescriptor[ret.size()]);
    }

    public IncludeRule[] getAllIncludeRules() {
        if (this.includeRules == null) {
            return new IncludeRule[0];
        }
        Set ret = this.mergeAll(this.includeRules);
        return ret.toArray(new IncludeRule[ret.size()]);
    }

    public ExcludeRule[] getAllExcludeRules() {
        if (this.excludeRules == null) {
            return new ExcludeRule[0];
        }
        Set ret = this.mergeAll(this.excludeRules);
        return ret.toArray(new ExcludeRule[ret.size()]);
    }

    private Set mergeAll(Map artifactsMap) {
        LinkedHashSet ret = new LinkedHashSet();
        Iterator it = artifactsMap.values().iterator();
        while (it.hasNext()) {
            Collection artifacts = (Collection)it.next();
            ret.addAll(artifacts);
        }
        return ret;
    }

    public void addDependencyConfiguration(String masterConf, String depConf) {
        Configuration config;
        if (this.md != null && !"*".equals(masterConf) && !"%".equals(masterConf) && (config = masterConf.startsWith("!") ? this.md.getConfiguration(masterConf.substring(1)) : this.md.getConfiguration(masterConf)) == null) {
            throw new IllegalArgumentException("Cannot add dependency '" + this.revId + "' to configuration '" + masterConf + "' of module " + this.md.getModuleRevisionId() + " because this configuration doesn't exist!");
        }
        ArrayList<String> confsList = (ArrayList<String>)this.confs.get(masterConf);
        if (confsList == null) {
            confsList = new ArrayList<String>();
            this.confs.put(masterConf, confsList);
        }
        if (!confsList.contains(depConf)) {
            confsList.add(depConf);
        }
    }

    public void addDependencyArtifact(String masterConf, DependencyArtifactDescriptor dad) {
        this.addObjectToConfiguration(masterConf, dad, this.getDependencyArtifacts());
    }

    public void addIncludeRule(String masterConf, IncludeRule rule) {
        this.addObjectToConfiguration(masterConf, rule, this.getIncludeRules());
    }

    public void addExcludeRule(String masterConf, ExcludeRule rule) {
        this.addObjectToConfiguration(masterConf, rule, this.getExcludeRules());
    }

    private void addObjectToConfiguration(String callerConf, Object toAdd, Map confsMap) {
        ArrayList<Object> col = (ArrayList<Object>)confsMap.get(callerConf);
        if (col == null) {
            col = new ArrayList<Object>();
            confsMap.put(callerConf, col);
        }
        col.add(toAdd);
    }

    public boolean doesExclude(String[] moduleConfigurations, ArtifactId artifactId) {
        if (this.namespace != null) {
            artifactId = NameSpaceHelper.transform(artifactId, this.namespace.getFromSystemTransformer());
        }
        ExcludeRule[] rules = this.getExcludeRules(moduleConfigurations);
        for (int i = 0; i < rules.length; ++i) {
            if (!MatcherHelper.matches(rules[i].getMatcher(), rules[i].getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    public boolean canExclude() {
        return this.excludeRules != null && !this.excludeRules.isEmpty();
    }

    public String toString() {
        return "dependency: " + this.revId + " " + this.confs;
    }

    public boolean isForce() {
        return this.isForce;
    }

    public ModuleRevisionId getParentRevisionId() {
        return this.md != null ? this.md.getResolvedModuleRevisionId() : this.parentId;
    }

    public boolean isChanging() {
        return this.isChanging;
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getAttribute(String attName) {
        return this.revId.getAttribute(attName);
    }

    public Map getAttributes() {
        return this.revId.getAttributes();
    }

    public String getExtraAttribute(String attName) {
        return this.revId.getExtraAttribute(attName);
    }

    public Map getExtraAttributes() {
        return this.revId.getExtraAttributes();
    }

    public Map getQualifiedExtraAttributes() {
        return this.revId.getQualifiedExtraAttributes();
    }

    public DependencyDescriptor asSystem() {
        return this.asSystem;
    }

    private void setDependencyArtifacts(Map dependencyArtifacts) {
        this.dependencyArtifacts = dependencyArtifacts;
    }

    private Map getDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            this.dependencyArtifacts = new LinkedHashMap();
        }
        return this.dependencyArtifacts;
    }

    private void setIncludeRules(Map includeRules) {
        this.includeRules = includeRules;
    }

    private Map getIncludeRules() {
        if (this.includeRules == null) {
            this.includeRules = new LinkedHashMap();
        }
        return this.includeRules;
    }

    private void setExcludeRules(Map excludeRules) {
        this.excludeRules = excludeRules;
    }

    private Map getExcludeRules() {
        if (this.excludeRules == null) {
            this.excludeRules = new LinkedHashMap();
        }
        return this.excludeRules;
    }

    public DependencyDescriptor clone(ModuleRevisionId revision) {
        return new DefaultDependencyDescriptor(this, revision);
    }
}

