/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.formatter;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Message;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.console.formatter.OutputFormatter;

public class CommandShellOutputFormatter
implements OutputFormatter {
    private OutputStream outputStream;
    private PrintStream out;

    public CommandShellOutputFormatter(OutputStream out) {
        this.outputStream = out;
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void printMBean(ObjectInstance mbean) {
        this.printMBean(mbean.getObjectName());
    }

    public void printMBean(ObjectName mbean) {
        this.printMBean(mbean.getKeyPropertyList());
    }

    public void printMBean(AttributeList mbean) {
        Iterator i = mbean.iterator();
        while (i.hasNext()) {
            Attribute attrib = (Attribute)i.next();
            if (attrib.getValue() instanceof ObjectName) {
                this.printMBean((ObjectName)attrib.getValue());
                continue;
            }
            if (attrib.getValue() instanceof ObjectInstance) {
                this.printMBean((ObjectInstance)attrib.getValue());
                continue;
            }
            this.out.println(attrib.getName() + " = " + attrib.getValue().toString());
            this.out.println();
        }
    }

    public void printMBean(Map mbean) {
        Iterator i = mbean.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String val = mbean.get(key).toString();
            this.out.println(key + " = " + val);
        }
        this.out.println();
    }

    public void printMBean(Collection mbean) {
        Iterator i = mbean.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof ObjectInstance) {
                this.printMBean((ObjectInstance)obj);
                continue;
            }
            if (obj instanceof ObjectName) {
                this.printMBean((ObjectName)obj);
                continue;
            }
            if (obj instanceof Map) {
                this.printMBean((Map)obj);
                continue;
            }
            if (obj instanceof AttributeList) {
                this.printMBean((AttributeList)obj);
                continue;
            }
            if (obj instanceof Collection) {
                this.printMessage((Collection)obj);
                continue;
            }
            this.printException(new UnsupportedOperationException("Unknown mbean type: " + obj.getClass().getName()));
        }
    }

    public void printMessage(Map msg) {
        Iterator i = msg.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String val = msg.get(key).toString();
            this.out.println(key + " = " + val);
        }
        this.out.println();
    }

    public void printMessage(Message msg) {
    }

    public void printMessage(Collection msg) {
        Iterator i = msg.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Message) {
                this.printMessage((Message)obj);
                continue;
            }
            if (obj instanceof Map) {
                this.printMessage((Map)obj);
                continue;
            }
            if (obj instanceof Collection) {
                this.printMessage((Collection)obj);
                continue;
            }
            this.printException(new UnsupportedOperationException("Unknown message type: " + obj.getClass().getName()));
        }
    }

    public void printHelp(String[] helpMsgs) {
        for (int i = 0; i < helpMsgs.length; ++i) {
            this.out.println(helpMsgs[i]);
        }
        this.out.println();
    }

    public void printInfo(String info) {
        this.out.println("INFO: " + info);
    }

    public void printException(Exception e) {
        this.out.println("ERROR: " + e);
        e.printStackTrace(this.out);
    }

    public void printVersion(String version) {
        this.out.println("");
        this.out.println("ActiveMQ " + version);
        this.out.println("For help or more information please see: http://www.logicblaze.com");
        this.out.println("");
    }

    public void print(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String val = map.get(key).toString();
            this.out.println(key + " = " + val);
        }
        this.out.println();
    }

    public void print(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            this.out.println(strings[i]);
        }
        this.out.println();
    }

    public void print(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            this.out.println(i.next().toString());
        }
        this.out.println();
    }

    public void print(String string) {
        this.out.println(string);
    }
}

