/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.txt;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemAttribute;
import com.vladium.emma.report.ItemComparator;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Files;
import com.vladium.util.IProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public final class ReportGenerator
extends AbstractReportGenerator
implements IAppErrorCodes {
    private char m_separator = (char)9;
    private LinkedList m_queue;
    private BufferedWriter m_out;
    private static final String TYPE = "txt";
    private static final String LINE = "-------------------------------------------------------------------------------";
    private static final int IO_BUF_SIZE = 32768;

    public String getType() {
        return TYPE;
    }

    public void process(IMetaData mdata, ICoverageData cdata, SourcePathCache cache, IProperties properties) throws EMMARuntimeException {
        this.initialize(mdata, cdata, cache, properties);
        long start = 0L;
        boolean trace1 = this.m_log.atTRACE1();
        if (trace1) {
            start = System.currentTimeMillis();
        }
        this.m_queue = new LinkedList();
        this.m_queue.add(this.m_view.getRoot());
        while (!this.m_queue.isEmpty()) {
            IItem head = (IItem)this.m_queue.removeFirst();
            head.accept(this, null);
        }
        this.line();
        this.close();
        if (trace1) {
            long end = System.currentTimeMillis();
            this.m_log.trace1("process", "[" + this.getType() + "] report generated in " + (end - start) + " ms");
        }
    }

    public void cleanup() {
        this.m_queue = null;
        this.close();
        super.cleanup();
    }

    public Object visit(AllItem item, Object ctx) {
        File outFile = this.m_settings.getOutFile();
        if (outFile == null) {
            outFile = new File("coverage.txt");
            this.m_settings.setOutFile(outFile);
        }
        File fullOutFile = Files.newFile(this.m_settings.getOutDir(), outFile);
        this.m_log.info("writing [" + this.getType() + "] report to [" + fullOutFile.getAbsolutePath() + "] ...");
        this.openOutFile(fullOutFile, this.m_settings.getOutEncoding(), true);
        try {
            StringBuffer label = new StringBuffer(101);
            label.append("[");
            label.append("EMMA");
            label.append(" v");
            label.append("2.0.9414 (unsupported private build)");
            label.append(" report, generated ");
            label.append(new Date(EMMAProperties.getTimeStamp()));
            label.append("]");
            this.m_out.write(label.toString());
            this.m_out.newLine();
            this.m_out.flush();
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
        int[] columns = this.m_settings.getColumnOrder();
        this.line();
        this.addTitleRow("OVERALL COVERAGE SUMMARY", 0, 1);
        this.addHeaderRow(item, columns);
        this.addItemRow(item, columns);
        this.addTitleRow("OVERALL STATS SUMMARY", 1, 1);
        this.row("total packages:" + this.m_separator + item.getChildCount());
        this.row("total classes:" + this.m_separator + item.getAggregate(11));
        this.row("total methods:" + this.m_separator + item.getAggregate(10));
        if (this.m_srcView && this.m_hasSrcFileInfo) {
            this.row("total executable files:" + this.m_separator + item.getAggregate(12));
            if (this.m_hasLineNumberInfo) {
                this.row("total executable lines:" + this.m_separator + item.getAggregate(7));
            }
        }
        boolean deeper = this.m_settings.getDepth() > item.getMetadata().getTypeID();
        this.addTitleRow("COVERAGE BREAKDOWN BY PACKAGE", 1, 1);
        boolean headerDone = false;
        ItemComparator order = this.m_typeSortComparators[PackageItem.getTypeMetadata().getTypeID()];
        Iterator packages = item.getChildren(order);
        while (packages.hasNext()) {
            IItem pkg = (IItem)packages.next();
            if (!headerDone) {
                this.addHeaderRow(pkg, columns);
                headerDone = true;
            }
            this.addItemRow(pkg, columns);
            if (!deeper) continue;
            this.m_queue.addLast(pkg);
        }
        return ctx;
    }

    public Object visit(PackageItem item, Object ctx) {
        if (this.m_verbose) {
            this.m_log.verbose("  report: processing package [" + item.getName() + "] ...");
        }
        int[] columns = this.m_settings.getColumnOrder();
        this.line();
        this.addTitleRow("COVERAGE SUMMARY FOR PACKAGE [".concat(item.getName()).concat("]"), 0, 1);
        this.addHeaderRow(item, columns);
        this.addItemRow(item, columns);
        boolean deeper = this.m_settings.getDepth() > item.getMetadata().getTypeID();
        String summaryTitle = this.m_srcView ? "COVERAGE BREAKDOWN BY SOURCE FILE" : "COVERAGE BREAKDOWN BY CLASS";
        this.addTitleRow(summaryTitle, 1, 1);
        boolean headerDone = false;
        ItemComparator order = this.m_typeSortComparators[this.m_srcView ? SrcFileItem.getTypeMetadata().getTypeID() : ClassItem.getTypeMetadata().getTypeID()];
        Iterator srcORclsFiles = item.getChildren(order);
        while (srcORclsFiles.hasNext()) {
            IItem srcORcls = (IItem)srcORclsFiles.next();
            if (!headerDone) {
                this.addHeaderRow(srcORcls, columns);
                headerDone = true;
            }
            this.addItemRow(srcORcls, columns);
            if (!deeper) continue;
            this.m_queue.addLast(srcORcls);
        }
        return ctx;
    }

    public Object visit(SrcFileItem item, Object ctx) {
        int[] columns = this.m_settings.getColumnOrder();
        this.line();
        this.addTitleRow("COVERAGE SUMMARY FOR SOURCE FILE [".concat(item.getName()).concat("]"), 0, 1);
        this.addHeaderRow(item, columns);
        this.addItemRow(item, columns);
        this.addTitleRow("COVERAGE BREAKDOWN BY CLASS AND METHOD", 1, 1);
        boolean headerDone = false;
        ItemComparator order = this.m_typeSortComparators[ClassItem.getTypeMetadata().getTypeID()];
        Iterator classes = item.getChildren(order);
        while (classes.hasNext()) {
            IItem cls = (IItem)classes.next();
            if (!headerDone) {
                this.addHeaderRow(cls, columns);
                headerDone = true;
            }
            this.addTitleRow("class [" + cls.getName() + "] methods", 0, 0);
            ItemComparator order2 = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
            Iterator methods = cls.getChildren(order2);
            while (methods.hasNext()) {
                MethodItem method = (MethodItem)methods.next();
                this.addItemRow(method, columns);
            }
        }
        return ctx;
    }

    public Object visit(ClassItem item, Object ctx) {
        int[] columns = this.m_settings.getColumnOrder();
        this.line();
        this.addTitleRow("COVERAGE SUMMARY FOR CLASS [".concat(item.getName()).concat("]"), 0, 1);
        this.addHeaderRow(item, columns);
        this.addItemRow(item, columns);
        this.addTitleRow("COVERAGE BREAKDOWN BY METHOD", 1, 1);
        ItemComparator order = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
        Iterator methods = item.getChildren(order);
        while (methods.hasNext()) {
            IItem method = (IItem)methods.next();
            this.addItemRow(method, columns);
        }
        return ctx;
    }

    private void addTitleRow(String text, int hlines, int flines) {
        int i;
        for (i = 0; i < hlines; ++i) {
            this.eol();
        }
        this.row(new StringBuffer(text).append(":"));
        for (i = 0; i < flines; ++i) {
            this.eol();
        }
    }

    private void addHeaderRow(IItem item, int[] columns) {
        StringBuffer buf = new StringBuffer();
        int cLimit = columns.length;
        for (int c = 0; c < cLimit; ++c) {
            int attrID = columns[c];
            IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
            if (attr != null) {
                buf.append('[');
                buf.append(attr.getName());
                buf.append(']');
            }
            if (c == cLimit - 1) continue;
            buf.append(this.m_separator);
        }
        this.row(buf);
    }

    private void addItemRow(IItem item, int[] columns) {
        StringBuffer buf = new StringBuffer(11);
        int cLimit = columns.length;
        for (int c = 0; c < cLimit; ++c) {
            int attrID = columns[c];
            IItemAttribute attr = item.getAttribute(attrID, this.m_settings.getUnitsType());
            if (attr != null) {
                boolean fail;
                boolean bl = fail = this.m_metrics[attrID] > 0 && !attr.passes(item, this.m_metrics[attrID]);
                if (fail) {
                    attr.format(item, buf);
                    buf.append('!');
                } else {
                    attr.format(item, buf);
                }
            }
            if (c == cLimit - 1) continue;
            buf.append(this.m_separator);
        }
        this.row(buf);
    }

    private void row(StringBuffer str) {
        try {
            this.m_out.write(str.toString());
            this.m_out.newLine();
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
    }

    private void row(String str) {
        try {
            this.m_out.write(str);
            this.m_out.newLine();
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
    }

    private void line() {
        try {
            this.m_out.write(LINE);
            this.m_out.newLine();
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
    }

    private void eol() {
        try {
            this.m_out.newLine();
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
    }

    private void close() {
        if (this.m_out != null) {
            try {
                this.m_out.flush();
                this.m_out.close();
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
            }
            finally {
                this.m_out = null;
            }
        }
    }

    private void openOutFile(File file, String encoding, boolean mkdirs) {
        try {
            File parent;
            if (mkdirs && (parent = file.getParentFile()) != null) {
                parent.mkdirs();
            }
            this.m_out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding), 32768);
        }
        catch (UnsupportedEncodingException uee) {
            throw new EMMARuntimeException(uee);
        }
        catch (IOException fnfe) {
            throw new EMMARuntimeException(fnfe);
        }
    }
}

