/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.timer;

import com.sun.messaging.jmq.util.timer.JMQTimer;
import com.sun.messaging.jmq.util.timer.JMQTimerTask;
import com.sun.messaging.jmq.util.timer.TaskQueue;

class TimerThread
extends Thread {
    boolean newTasksMayBeScheduled = true;
    private TaskQueue queue;

    TimerThread(TaskQueue taskQueue) {
        this.setName("JMQTimerThread");
        this.queue = taskQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = true;
        try {
            while (bl) {
                try {
                    bl = this.mainLoop();
                }
                catch (RuntimeException runtimeException) {
                    if (JMQTimer.logger == null) continue;
                    RuntimeException runtimeException2 = new RuntimeException("Runtime Exception in timer, ignoring ");
                    runtimeException2.initCause(runtimeException);
                    runtimeException2.fillInStackTrace();
                    JMQTimer.logger.logStack(16, "Internal error: exception processing timer", (Throwable)runtimeException2);
                }
                catch (Throwable throwable) {
                    bl = false;
                    if (JMQTimer.logger != null) {
                        JMQTimer.logger.logStack(16, "Internal error: throwable received processing timer, exiting", throwable);
                    }
                    break;
                }
            }
        }
        finally {
            TaskQueue taskQueue = this.queue;
            synchronized (taskQueue) {
                this.newTasksMayBeScheduled = false;
                this.queue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mainLoop() {
        block8: while (true) {
            try {
                while (true) {
                    boolean bl;
                    JMQTimerTask jMQTimerTask;
                    TaskQueue taskQueue = this.queue;
                    synchronized (taskQueue) {
                        long l;
                        long l2;
                        while (this.queue.isEmpty() && this.newTasksMayBeScheduled) {
                            this.queue.wait();
                        }
                        if (this.queue.isEmpty()) {
                            break block8;
                        }
                        if (!this.newTasksMayBeScheduled) {
                            break block8;
                        }
                        jMQTimerTask = this.queue.getMin();
                        Object object = jMQTimerTask.lock;
                        synchronized (object) {
                            if (jMQTimerTask.state == 3) {
                                this.queue.removeMin();
                                continue;
                            }
                            l2 = jMQTimerTask.nextExecutionTime;
                            l = System.currentTimeMillis();
                            bl = l2 <= l;
                            if (bl) {
                                if (jMQTimerTask.period == 0L) {
                                    this.queue.removeMin();
                                    jMQTimerTask.state = 2;
                                } else {
                                    this.queue.rescheduleMin(jMQTimerTask.period < 0L ? l - jMQTimerTask.period : l2 + jMQTimerTask.period);
                                }
                            }
                        }
                        if (!bl) {
                            this.queue.wait(l2 - l);
                        }
                    }
                    if (!bl) continue;
                    jMQTimerTask.run();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return this.newTasksMayBeScheduled;
    }
}

