/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.InterestTable;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.ReadChannel;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.Message;

public class WriteChannel {
    private boolean debug = Debug.debug;
    private ProtocolHandler protocolHandler = null;
    private ReadChannel readChannel = null;
    private InterestTable interestTable = null;
    private ConnectionImpl connection = null;
    public static final String JMQSize = "JMQSize";
    private boolean shouldPause = false;
    private int flowCount = -1;
    protected boolean turnOffFlowControl = false;

    public WriteChannel(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        this.protocolHandler = connectionImpl.getProtocolHandler();
        this.readChannel = connectionImpl.getReadChannel();
        this.interestTable = connectionImpl.getInterestTable();
        if (System.getProperty("NoimqProducerFlowControl") != null) {
            this.turnOffFlowControl = true;
        }
    }

    protected void setReadChannel(ReadChannel readChannel) {
        this.readChannel = readChannel;
    }

    protected void addInterest(Consumer consumer) throws JMSException {
        this.protocolHandler.addInterest(consumer);
    }

    protected void removeInterest(Consumer consumer) throws JMSException {
        this.protocolHandler.removeInterest(consumer);
    }

    protected void unsubscribe(String string) throws JMSException {
        this.protocolHandler.unsubscribe(string);
    }

    protected void writeJMSMessage(Message message) throws JMSException {
        if (this.turnOffFlowControl && this.connection.getBrokerProtocolLevel() < 350) {
            this.protocolHandler.writeJMSMessage(message);
        } else {
            this.sendWithFlowControl(message);
        }
    }

    protected void updateFlowControl(ReadOnlyPacket readOnlyPacket) throws JMSException {
        int n = -1;
        try {
            Integer n2 = (Integer)readOnlyPacket.getProperties().get(JMQSize);
            if (n2 != null) {
                n = n2;
            }
        }
        catch (IOException iOException) {
            ExceptionHandler cfr_ignored_0 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(iOException, "C4005", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler cfr_ignored_1 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(classNotFoundException, "C4005", true);
        }
        this.setFlowCount(n);
    }

    private synchronized void setFlowCount(int n) {
        this.flowCount = n;
        this.notifyAll();
    }

    protected void sendWithFlowControl(Message message) throws JMSException {
        this.pause(message);
        this.protocolHandler.writeJMSMessage(message);
    }

    protected synchronized void pause(Message message) {
        while (this.flowCount == 0) {
            if (this.debug) {
                Debug.println("WriteChannel : Waiting for RESUME_FLOW");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.debug) {
            Debug.println("WriteChannel : wait() returned...");
        }
        if (this.flowCount > 0) {
            --this.flowCount;
        }
        if (this.flowCount == 0) {
            ((MessageImpl)message).getPacket().setFlowPaused(true);
        } else {
            ((MessageImpl)message).getPacket().setFlowPaused(false);
        }
    }

    protected void close() {
        if (this.debug) {
            Debug.println("WriteChannel.close() : Waking up blocked producers");
        }
        this.setFlowCount(-1);
    }
}

