/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import groovyjarjarantlr.RecognitionException;
import groovyjarjarantlr.TokenStreamException;
import java.io.File;
import java.io.IOException;
import org.codehaus.groovy.groovydoc.GroovyRootDoc;
import org.codehaus.groovy.tools.groovydoc.GroovyDocTemplateEngine;
import org.codehaus.groovy.tools.groovydoc.GroovyDocWriter;
import org.codehaus.groovy.tools.groovydoc.GroovyRootDocBuilder;
import org.codehaus.groovy.tools.groovydoc.OutputTool;
import org.codehaus.groovy.tools.groovydoc.ResourceManager;

public class GroovyDocTool {
    private final GroovyRootDocBuilder rootDocBuilder;
    private final GroovyDocTemplateEngine templateEngine;

    public GroovyDocTool(String sourcepath) {
        this(null, sourcepath, null);
    }

    public GroovyDocTool(ResourceManager resourceManager, String sourcepath, String classTemplate) {
        this(resourceManager, sourcepath, new String[0], new String[0], new String[]{classTemplate});
    }

    public GroovyDocTool(ResourceManager resourceManager, String sourcepath, String[] docTemplates, String[] packageTemplates, String[] classTemplates) {
        this.rootDocBuilder = new GroovyRootDocBuilder(this, sourcepath);
        this.templateEngine = resourceManager == null ? null : new GroovyDocTemplateEngine(this, resourceManager, docTemplates, packageTemplates, classTemplates);
    }

    public void add(String filename) throws RecognitionException, TokenStreamException, IOException {
        if (this.templateEngine != null) {
            System.out.println("Loading source files for " + filename);
        }
        this.rootDocBuilder.buildTree(filename);
    }

    public GroovyRootDoc getRootDoc() {
        return this.rootDocBuilder.getRootDoc();
    }

    public void renderToOutput(OutputTool output, String destdir) throws Exception {
        if (this.templateEngine == null) {
            throw new UnsupportedOperationException("No template engine was found");
        }
        GroovyDocWriter writer = new GroovyDocWriter(this, output, this.templateEngine);
        GroovyRootDoc rootDoc = this.rootDocBuilder.getRootDoc();
        writer.writeRoot(rootDoc, destdir);
        writer.writePackages(rootDoc, destdir);
        writer.writeClasses(rootDoc, destdir);
    }

    String getPath(String filename) {
        String path = new File(filename).getParent();
        if (path == null || path.length() == 1) {
            path = "DefaultPackage";
        }
        return path;
    }

    String getFile(String filename) {
        return new File(filename).getName();
    }
}

