/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.visualization;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.EventNode;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.parser.Debug;

public class DotVisualizer {
    private ActionRepository repository;
    private String legend;
    private int explicitidx;

    public DotVisualizer(ActionRepository repository) {
        this.repository = repository;
        this.legend = new String();
    }

    public int visualize(TreeNode node, String outputfile) {
        try {
            this.explicitidx = 0;
            this.legend = "";
            FileOutputStream of = new FileOutputStream(outputfile);
            of.write("digraph G {\n  size = \"7,11\";\n".getBytes());
            this.visualizeNode(node, of, 0);
            of.write(("  label=\"" + this.legend + "\";\n").getBytes());
            of.write("\n}".getBytes());
            of.close();
            Debug.println("Parse tree written to: " + outputfile);
            return 0;
        }
        catch (FileNotFoundException e) {
            return 1;
        }
        catch (SecurityException e) {
            return 2;
        }
        catch (IOException e) {
            return 3;
        }
    }

    private int visualizeNode(TreeNode node, FileOutputStream of, int nodeindex) throws IOException {
        String[] nodenames = node.getTypeName();
        String nodename = nodenames[0];
        String purename = new String(nodename);
        nodename = nodename + nodeindex++;
        if (purename.equals("Event")) {
            nodenames[1] = this.repository.getItemString(((EventNode)node).getEventIndex());
            of.write(("  " + nodename + " [label=\"" + nodenames[1] + "\", fontname=\"Courier\"];\n").getBytes());
        } else if (purename.equals("Explicit")) {
            of.write(("  " + nodename + " [label=\"Exp" + this.explicitidx + "\", fontname=\"Courier\", shape=invhouse, style=filled, fillcolor=\"grey85\"];\n").getBytes());
            this.legend = this.legend + "Exp" + this.explicitidx + ": " + node.protocol + "\\n";
            ++this.explicitidx;
        } else {
            of.write(("  " + nodename + " [label=\"" + nodenames[1] + "\", fontname=\"Courier-Bold\"];\n").getBytes());
        }
        TreeNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            String[] childnames = children[i].getTypeName();
            String childname = childnames[0];
            childname = childname + nodeindex;
            of.write(("\t" + nodename + " -> " + childname + ";\n").getBytes());
            nodeindex = this.visualizeNode(children[i], of, nodeindex);
        }
        return nodeindex;
    }
}

