/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.objectweb.fractal.bpc.checker.node.AlternativeNode;
import org.objectweb.fractal.bpc.checker.node.AndParallelNode;
import org.objectweb.fractal.bpc.checker.node.AtomicNode;
import org.objectweb.fractal.bpc.checker.node.ConsentNode;
import org.objectweb.fractal.bpc.checker.node.DeterministicNode;
import org.objectweb.fractal.bpc.checker.node.EventNode;
import org.objectweb.fractal.bpc.checker.node.NullNode;
import org.objectweb.fractal.bpc.checker.node.RepetitionNode;
import org.objectweb.fractal.bpc.checker.node.SequenceNode;
import org.objectweb.fractal.bpc.checker.node.TreeNode;

public class ProtocolUsageMonitor {
    private static HashMap table = new HashMap();

    public static void eventGenerated(int eventidx, EventNode node) {
        Integer key = new Integer(eventidx);
        if (table.containsKey(key)) {
            ((LinkedList)table.get(key)).add(node);
        } else {
            LinkedList<EventNode> list = new LinkedList<EventNode>();
            list.add(node);
            table.put(key, list);
        }
    }

    public static void eventExecuted(int eventidx) {
        LinkedList list = (LinkedList)table.get(new Integer(eventidx));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ((EventNode)it.next()).setExecuted();
        }
        table.clear();
    }

    public static void eventsExecuted(int acceptEventIdx, int emitEventIdx) {
        LinkedList list1 = (LinkedList)table.get(new Integer(acceptEventIdx));
        Iterator it1 = list1.iterator();
        while (it1.hasNext()) {
            ((EventNode)it1.next()).setExecuted();
        }
        LinkedList list2 = (LinkedList)table.get(new Integer(emitEventIdx));
        Iterator it2 = list2.iterator();
        while (it2.hasNext()) {
            ((EventNode)it2.next()).setExecuted();
        }
        table.clear();
    }

    public static void printUsage(OutputStream out, TreeNode root) throws IOException {
        out.write(new String("<html><head /><body><pre>\n").getBytes());
        out.write(32);
        ProtocolUsageMonitor.doPrint(out, root, " ");
        out.write(new String("</pre></body></html>\n").getBytes());
    }

    private static void doPrint(OutputStream out, TreeNode root, String prefix) throws IOException {
        TreeNode[] children = root.getChildren();
        if (root instanceof EventNode) {
            if (!((EventNode)root).getExecuted()) {
                out.write(new String("<strong><font color=\"#FF0000\">").getBytes());
                out.write(root.protocol.getBytes());
                out.write(new String("</font></strong>").getBytes());
            } else {
                out.write(root.protocol.getBytes());
            }
        } else if (root instanceof AtomicNode) {
            out.write(root.protocol.getBytes());
        } else if (root instanceof RepetitionNode) {
            ProtocolUsageMonitor.doPrint(out, children[0], prefix);
            out.write(42);
        } else if (root instanceof DeterministicNode) {
            ProtocolUsageMonitor.doPrint(out, children[0], prefix);
        } else if (root instanceof NullNode) {
            out.write("NULL".getBytes());
        } else {
            out.write(new String("(\n" + prefix + "   ").getBytes());
            ProtocolUsageMonitor.doPrint(out, children[0], prefix + "   ");
            for (int i = 1; i < children.length; ++i) {
                if (root instanceof AlternativeNode) {
                    out.write(("\n" + prefix + "+" + "\n" + prefix + "   ").getBytes());
                    ProtocolUsageMonitor.doPrint(out, children[i], prefix + "   ");
                    continue;
                }
                if (root instanceof AndParallelNode) {
                    out.write(("\n" + prefix + "|" + "\n" + prefix + "   ").getBytes());
                    ProtocolUsageMonitor.doPrint(out, children[i], prefix + "   ");
                    continue;
                }
                if (root instanceof ConsentNode) {
                    out.write(("\n\n\n" + prefix + "<consent>" + "\n\n\n" + prefix + "   ").getBytes());
                    ProtocolUsageMonitor.doPrint(out, children[i], prefix + "   ");
                    continue;
                }
                if (!(root instanceof SequenceNode)) continue;
                out.write(" ; ".getBytes());
                ProtocolUsageMonitor.doPrint(out, children[i], prefix + "   ");
            }
            out.write(("\n" + prefix + ")").getBytes());
        }
    }
}

