/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public class AnotatedProtocol {
    public String protocol;
    public ArrayList indices;
    private static final String INDENT = "   ";

    public AnotatedProtocol(String protocol, ArrayList indices) {
        this.protocol = protocol;
        this.indices = indices;
    }

    public void prettyPrint(boolean file) {
        try {
            if (!file) {
                this.doPrettyPrint(System.out, "");
            } else {
                FileOutputStream f = new FileOutputStream("protocol.html");
                this.doPrettyPrint(f, "");
                f.close();
            }
        }
        catch (IOException e) {
            System.out.println("Error while writing protocol state");
        }
    }

    public void doPrettyPrint(OutputStream stream, String indent) throws IOException {
        TreeSet sorted = new TreeSet(this.indices);
        Iterator it = sorted.iterator();
        stream.write(10);
        stream.write(new String("<html><head /><body><pre>").getBytes());
        int index = it.hasNext() ? (Integer)it.next() : -1;
        for (int i = 0; i < this.protocol.length(); ++i) {
            char c;
            if (index == i) {
                stream.write(new String("<FONT COLOR=\"#00AA00\">").getBytes());
                stream.write(new String("&lt;HERE&gt;").getBytes());
                stream.write(new String("</FONT>").getBytes());
                int n = index = it.hasNext() ? (Integer)it.next() : -1;
            }
            if ((c = this.protocol.charAt(i)) == '%') {
                stream.write(new String("\n<BR><hr>\n").getBytes());
                indent = "";
                continue;
            }
            if (c == '(') {
                stream.write(10);
                stream.write(indent.getBytes());
                stream.write(40);
                indent = indent + INDENT;
                continue;
            }
            if (c == ')') {
                char bc = this.protocol.charAt(i - 1);
                if (bc != '$' && bc != '^' && bc != ']') {
                    stream.write(10);
                    indent = indent.substring(0, indent.length() - INDENT.length());
                    stream.write(indent.getBytes());
                } else {
                    indent = indent.substring(0, indent.length() - INDENT.length());
                }
                stream.write(41);
                if (this.protocol.length() <= i + 1 || this.protocol.charAt(i + 1) == '*' || this.protocol.charAt(i + 1) == ';' || this.protocol.charAt(i + 1) == ')') continue;
                stream.write(10);
                stream.write(indent.getBytes());
                continue;
            }
            if (c == '{') {
                stream.write(10);
                stream.write(indent.getBytes());
                stream.write(123);
                indent = indent + INDENT;
                continue;
            }
            if (c == '}') {
                stream.write(10);
                indent = indent.substring(0, indent.length() - INDENT.length());
                stream.write(indent.getBytes());
                stream.write(125);
                stream.write(10);
                stream.write(indent.getBytes());
                continue;
            }
            if (c == '+') {
                stream.write(43);
                stream.write(indent.getBytes());
                continue;
            }
            stream.write(this.protocol.charAt(i));
        }
        stream.write(10);
        stream.write(new String("</pre></body></html>").getBytes());
    }
}

