/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.state;

import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.AlternativeNode;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.state.State;

public class DenotedState
extends State {
    public final int index;
    public final State state;
    private int children;
    private AlternativeNode root;

    public DenotedState(int index, State state, int children, AlternativeNode root) {
        this.index = index;
        this.state = state;
        this.children = children;
        this.root = root;
    }

    protected void createSignature() {
        boolean acc = this.root.isAccepting(this) | this.index == -2;
        if (this.index == -1) {
            for (int i = 0; i < this.children; ++i) {
                this.signature.set(i, true);
            }
        } else if (acc && !this.hasAncestors()) {
            for (int i = 0; i < this.children; ++i) {
                this.signature.set(i, false);
            }
        } else {
            for (int i = 0; i < this.children; ++i) {
                this.signature.set(i, (this.index & 1 << i) != 0);
            }
            this.signature.concat(this.state.getSignature());
        }
    }

    public boolean equals(State another) {
        if (!(another instanceof DenotedState)) {
            return false;
        }
        DenotedState dstate = (DenotedState)another;
        if (this.index != dstate.index) {
            return false;
        }
        if (this.signature == null) {
            this.getSignature();
        }
        if (another.signature == null) {
            another.getSignature();
        }
        return this.getSignature().equals(dstate.getSignature());
    }

    private boolean hasAncestors() {
        try {
            return this.root.getTransitions((State)this).transitions.length > 0;
        }
        catch (InvalidParameterException e) {
            return true;
        }
        catch (CheckingException e) {
            return true;
        }
    }
}

