/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.state;

public class BitList
implements Comparable {
    private int[] buffer = new int[1];
    private int max;
    private int length;

    public BitList(int size) {
        this.max = size;
        this.length = 0;
    }

    public void set(int position, boolean bit) {
        int idx = position >> 5;
        int off = position & 0x1F;
        if (idx >= this.buffer.length) {
            int size = this.buffer.length * 2;
            int[] newbuffer = new int[size];
            for (int i = 0; i < this.buffer.length; ++i) {
                newbuffer[i] = this.buffer[i];
            }
            this.buffer = newbuffer;
        }
        this.buffer[idx] = bit ? this.buffer[idx] | 1 << 31 - off : this.buffer[idx] & ~(1 << 31 - off);
        if (position >= this.length) {
            this.length = position + 1;
        }
    }

    public boolean get(int position) {
        int idx = position >> 5;
        int off = position & 0x1F;
        return (this.buffer[idx] & 1 << off) == 0;
    }

    public int compareTo(Object o) {
        if (!(o instanceof BitList)) {
            return -1;
        }
        BitList other = (BitList)o;
        int min = this.buffer.length < other.buffer.length ? this.buffer.length : other.buffer.length;
        for (int i = 0; i < min; ++i) {
            if (this.buffer[i] < other.buffer[i]) {
                return -1;
            }
            if (this.buffer[i] <= other.buffer[i]) continue;
            return 1;
        }
        if (this.length < other.length) {
            return -1;
        }
        if (this.length > other.length) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitList)) {
            return false;
        }
        BitList other = (BitList)o;
        if (this.length != other.length) {
            return false;
        }
        int min = this.buffer.length;
        for (int i = 0; i < min; ++i) {
            if (this.buffer[i] == other.buffer[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            result ^= this.buffer[i] << i;
        }
        return result;
    }

    public void concat(BitList second) {
        int thisidx = this.length >> 5;
        int thisoff = this.length & 0x1F;
        int secondleft = second.length;
        int needed = (this.length + second.length >> 5) + ((this.length + second.length & 0x1F) != 0 ? 1 : 0);
        if (needed >= this.buffer.length) {
            int size = this.buffer.length * 2 > needed ? this.buffer.length * 2 : needed;
            int[] newbuffer = new int[size];
            for (int i = 0; i < this.buffer.length; ++i) {
                newbuffer[i] = this.buffer[i];
            }
            this.buffer = newbuffer;
        }
        int i = 0;
        while (secondleft > 0) {
            int n = thisidx + i;
            this.buffer[n] = this.buffer[n] | second.buffer[i] >>> thisoff;
            if (secondleft - 32 + thisoff > 0 && thisoff > 0) {
                int n2 = thisidx + i + 1;
                this.buffer[n2] = this.buffer[n2] | second.buffer[i] << 32 - thisoff;
            }
            ++i;
            secondleft -= 32;
        }
        this.length += second.length;
    }

    public String toString() {
        String s = new String();
        for (int i = 0; i < this.length; ++i) {
            s = s + ((this.buffer[i >> 5] & 1 << 31 - i) != 0 ? "1" : "0");
        }
        return s;
    }

    public int[] getBuffer() {
        return this.buffer;
    }
}

