/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.parser;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.objectweb.fractal.bpc.checker.parser.ProtocolReader;

public class FileTokenizer
extends ProtocolReader {
    private FileReader reader;
    private int index = 0;

    public FileTokenizer(String filename) throws IOException {
        try {
            this.reader = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            throw new IOException();
        }
    }

    public int read() throws IOException {
        int read = 65535;
        while (this.reader.ready()) {
            read = (char)this.reader.read();
            if (read == 32 || read == 9 || read == 10 || read == 13) continue;
            if (read != 35) break;
            String line = this.getLine();
            if (!line.equals("eop")) continue;
            return -1;
        }
        if (read != -1) {
            ++this.index;
            return read;
        }
        return -1;
    }

    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    public int getIndex() {
        return this.index;
    }

    public int read(char[] arg0, int arg1, int arg2) throws IOException {
        throw new IOException("Not implemented");
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void resetIndex() {
        this.index = 0;
    }

    private String getLine() throws IOException {
        char read;
        String line = new String();
        while (this.reader.ready() && (read = (char)this.reader.read()) != '\n' && read != '\r') {
            line = line + read;
        }
        return line;
    }
}

