/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.parser;

import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.AdjustmentNode;
import org.objectweb.fractal.bpc.checker.node.AlternativeNode;
import org.objectweb.fractal.bpc.checker.node.AndParallelNode;
import org.objectweb.fractal.bpc.checker.node.AtomicNode;
import org.objectweb.fractal.bpc.checker.node.CompositionNode;
import org.objectweb.fractal.bpc.checker.node.EventNode;
import org.objectweb.fractal.bpc.checker.node.NullNode;
import org.objectweb.fractal.bpc.checker.node.RepetitionNode;
import org.objectweb.fractal.bpc.checker.node.RestrictionNode;
import org.objectweb.fractal.bpc.checker.node.SequenceNode;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.parser.Debug;
import org.objectweb.fractal.bpc.checker.parser.ProtocolReader;
import org.objectweb.fractal.bpc.checker.parser.SyntaxErrorException;

public class Builder {
    private boolean MULTINODES = true;
    private char next_char;
    private ProtocolReader source;
    private String next_token;
    private boolean isTokenID;
    private ActionRepository repository;
    private String protocol;
    private boolean runtime = false;

    public Builder(ActionRepository repository) {
        this.repository = repository;
        this.MULTINODES = Options.multinodes;
    }

    private static String getReverseAction(String src) {
        String e = src.startsWith("!") ? new String("?").concat(src.substring(1)) : (src.startsWith("?") ? new String("!").concat(src.substring(1)) : new String(src));
        return e;
    }

    private static boolean isSimpleCall(String src) {
        return !src.endsWith("^") && !src.endsWith("$") && !src.endsWith("~") && !src.endsWith("[");
    }

    private boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch >= '0' && ch <= '9' || ch == ':';
    }

    public static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    private void nextPart(String part) {
        this.protocol = this.protocol + part;
        Debug.print(2, part);
    }

    private String nextToken() throws SyntaxErrorException, IOException {
        this.isTokenID = false;
        if (!this.source.ready()) {
            Debug.println(2, "");
            return "";
        }
        while (Builder.isWhiteSpace(this.next_char)) {
            if (this.source.ready()) {
                this.protocol = this.protocol + " ";
                this.next_char = (char)this.source.read();
                continue;
            }
            Debug.println(2, "");
            return "";
        }
        switch (this.next_char) {
            case '\uffff': {
                Debug.println(2, "");
                return "";
            }
            case '|': {
                this.next_char = (char)this.source.read();
                if (this.next_char == '|') {
                    this.next_char = (char)this.source.read();
                    this.nextPart("||");
                    return "||";
                }
                this.nextPart("|");
                return "|";
            }
            case '&': {
                this.next_char = (char)this.source.read();
                this.nextPart("&");
                return "&";
            }
            case '@': {
                this.next_char = (char)this.source.read();
                this.nextPart("@");
                return "@";
            }
            case '.': {
                this.next_char = (char)this.source.read();
                this.nextPart(".");
                return ".";
            }
            case '*': {
                this.next_char = (char)this.source.read();
                this.nextPart("*");
                return "*";
            }
            case '+': {
                this.next_char = (char)this.source.read();
                this.nextPart("+");
                return "+";
            }
            case ';': {
                this.next_char = (char)this.source.read();
                this.nextPart(";");
                return ";";
            }
            case ',': {
                this.next_char = (char)this.source.read();
                this.nextPart(",");
                return ",";
            }
            case '\\': {
                this.next_char = (char)this.source.read();
                this.nextPart("\\");
                return "\\";
            }
            case '{': {
                this.next_char = (char)this.source.read();
                this.nextPart("{");
                return "{";
            }
            case '}': {
                this.next_char = (char)this.source.read();
                this.nextPart("}");
                return "}";
            }
            case '(': {
                this.next_char = (char)this.source.read();
                this.nextPart("(");
                return "(";
            }
            case ')': {
                this.next_char = (char)this.source.read();
                this.nextPart(")");
                return ")";
            }
            case '[': {
                this.next_char = (char)this.source.read();
                this.nextPart("[");
                return "[";
            }
            case ']': {
                this.next_char = (char)this.source.read();
                this.nextPart("]");
                return "]";
            }
        }
        if (this.isLetter(this.next_char) || this.next_char == '?' || this.next_char == '!' || this.next_char == '<' || this.next_char == '#') {
            String result = "";
            if (this.next_char == '!' || this.next_char == '?' || this.next_char == '#') {
                result = result + this.next_char;
                this.next_char = (char)this.source.read();
            }
            if (this.next_char == '<') {
                do {
                    result = result + this.next_char;
                    this.next_char = (char)this.source.read();
                } while (this.next_char != '>');
                result = result + this.next_char;
                this.next_char = (char)this.source.read();
            } else {
                while (this.isLetter(this.next_char)) {
                    result = result + this.next_char;
                    this.next_char = (char)this.source.read();
                }
            }
            if (this.next_char != '.') {
                if (result.equals("NULL")) {
                    this.isTokenID = true;
                    this.nextPart(result);
                    return result;
                }
                throw new SyntaxErrorException("Invalid event name: dot delimiter expected in event name, found " + this.next_char + " after " + result);
            }
            result = result + this.next_char;
            this.next_char = (char)this.source.read();
            while (this.isLetter(this.next_char)) {
                result = result + this.next_char;
                this.next_char = (char)this.source.read();
            }
            if (this.next_char == '^' || this.next_char == '$' || this.next_char == '~') {
                result = result + this.next_char;
                this.next_char = (char)this.source.read();
            }
            this.isTokenID = true;
            this.nextPart(result);
            return result;
        }
        throw new SyntaxErrorException("Unexpected literal with code " + this.next_char);
    }

    private TreeNode alternative() throws SyntaxErrorException, IOException {
        Vector<TreeNode> nodelist = new Vector<TreeNode>();
        Vector<Integer> protindices = new Vector<Integer>();
        protindices.add(new Integer(this.source.getIndex() - this.next_token.length() - 1));
        nodelist.add(this.sequence());
        while (this.next_token == "+") {
            this.next_token = this.nextToken();
            nodelist.add(this.sequence());
            protindices.add(new Integer(this.source.getIndex() - this.next_token.length() - (this.next_token.length() > 0 ? 1 : 0)));
        }
        if (nodelist.size() > 1) {
            if (this.MULTINODES) {
                TreeNode[] nodes = new TreeNode[nodelist.size()];
                for (int i = 0; i < nodelist.size(); ++i) {
                    nodes[i] = (TreeNode)nodelist.get(i);
                }
                AlternativeNode newnode = new AlternativeNode(nodes);
                newnode.protocol = this.protocol.substring((Integer)protindices.get(0), (Integer)protindices.lastElement());
                return newnode;
            }
            TreeNode[] nodes = new TreeNode[2];
            TreeNode result = (TreeNode)nodelist.get(0);
            for (int i = 1; i < nodelist.size(); ++i) {
                nodes = new TreeNode[]{result, (TreeNode)nodelist.get(i)};
                result = new AlternativeNode(nodes);
                result.protocol = this.protocol.substring((Integer)protindices.get(0), (Integer)protindices.get(i));
            }
            return result;
        }
        return (TreeNode)nodelist.get(0);
    }

    private TreeNode sequence() throws SyntaxErrorException, IOException {
        Vector<TreeNode> nodelist = new Vector<TreeNode>();
        Vector<Integer> protindices = new Vector<Integer>();
        protindices.add(new Integer(this.source.getIndex() - this.next_token.length() - 1));
        nodelist.add(this.andparallel());
        while (this.next_token == ";") {
            this.next_token = this.nextToken();
            nodelist.add(this.andparallel());
            protindices.add(new Integer(this.source.getIndex() - this.next_token.length() - (this.next_token.length() > 0 ? 1 : 0)));
        }
        if (nodelist.size() > 1) {
            if (this.MULTINODES) {
                TreeNode[] nodes = new TreeNode[nodelist.size()];
                for (int i = 0; i < nodelist.size(); ++i) {
                    nodes[i] = (TreeNode)nodelist.get(i);
                }
                SequenceNode newnode = new SequenceNode(nodes);
                newnode.protocol = this.protocol.substring((Integer)protindices.get(0), (Integer)protindices.lastElement());
                return newnode;
            }
            TreeNode[] nodes = new TreeNode[2];
            TreeNode result = (TreeNode)nodelist.get(0);
            for (int i = 1; i < nodelist.size(); ++i) {
                nodes = new TreeNode[]{result, (TreeNode)nodelist.get(i)};
                result = new SequenceNode(nodes);
                result.protocol = this.protocol.substring((Integer)protindices.get(0), (Integer)protindices.get(i));
            }
            return result;
        }
        return (TreeNode)nodelist.get(0);
    }

    private TreeNode andparallel() throws SyntaxErrorException, IOException {
        Vector<TreeNode> nodelist = new Vector<TreeNode>();
        Vector<Integer> protindices = new Vector<Integer>();
        protindices.add(new Integer(this.source.getIndex() - this.next_token.length() - 1));
        nodelist.add(this.orparallel());
        while (this.next_token == "|") {
            this.next_token = this.nextToken();
            nodelist.add(this.orparallel());
            protindices.add(new Integer(this.source.getIndex() - this.next_token.length() - (this.next_token.length() > 0 ? 1 : 0)));
        }
        if (nodelist.size() > 1) {
            if (this.MULTINODES) {
                TreeNode[] nodes = new TreeNode[nodelist.size()];
                for (int i = 0; i < nodelist.size(); ++i) {
                    nodes[i] = (TreeNode)nodelist.get(i);
                }
                AndParallelNode newnode = new AndParallelNode(nodes);
                newnode.protocol = this.protocol.substring((Integer)protindices.get(0), (Integer)protindices.lastElement());
                return newnode;
            }
            TreeNode[] nodes = new TreeNode[2];
            TreeNode result = (TreeNode)nodelist.get(0);
            for (int i = 1; i < nodelist.size(); ++i) {
                nodes = new TreeNode[]{result, (TreeNode)nodelist.get(i)};
                result = new AndParallelNode(nodes);
                result.protocol = this.protocol.substring((Integer)protindices.get(0), (Integer)protindices.get(i));
            }
            return result;
        }
        return (TreeNode)nodelist.get(0);
    }

    private TreeNode orparallel() throws SyntaxErrorException, IOException {
        Vector<TreeNode> nodelist = new Vector<TreeNode>();
        Vector<Integer> protindices = new Vector<Integer>();
        protindices.add(new Integer(this.source.getIndex() - this.next_token.length() - 1));
        nodelist.add(this.term());
        while (this.next_token == "||") {
            this.next_token = this.nextToken();
            nodelist.add(this.term());
            protindices.add(new Integer(this.source.getIndex() - this.next_token.length() - (this.next_token.length() > 0 ? 1 : 0)));
        }
        TreeNode result = (TreeNode)nodelist.get(0);
        for (int i = 1; i < nodelist.size(); ++i) {
            TreeNode[] altnodes = new TreeNode[3];
            TreeNode[] apnodes = new TreeNode[]{result, (TreeNode)nodelist.get(i)};
            altnodes[0] = result;
            altnodes[1] = (TreeNode)nodelist.get(i);
            altnodes[2] = new AndParallelNode(apnodes);
            result = new AlternativeNode(altnodes);
            ((AlternativeNode)result).setorparallel();
            result.protocol = this.protocol.substring((Integer)protindices.get(0), (Integer)protindices.get(i));
        }
        return result;
    }

    private TreeSet collectList(String endmark) throws SyntaxErrorException, IOException {
        TreeSet<Integer> result = new TreeSet<Integer>();
        while (this.isTokenID) {
            if (this.next_token.startsWith("?") || this.next_token.startsWith("!") || this.next_token.startsWith("#")) {
                if (this.next_token.endsWith("^") || this.next_token.endsWith("$") || this.next_token.endsWith("~")) {
                    Debug.println(3, "CollectList: action token");
                    result.add(new Integer(this.repository.addItem(this.next_token)));
                } else {
                    Debug.println(3, "CollectList: action token without");
                    result.add(new Integer(this.repository.addItem(this.next_token + "^")));
                    result.add(new Integer(this.repository.addItem(Builder.getReverseAction(this.next_token + "$"))));
                }
            } else if (this.next_token.endsWith("^") || this.next_token.endsWith("$") || this.next_token.endsWith("~")) {
                Debug.println(3, "CollectList: adding event");
                result.add(new Integer(this.repository.addItem("?" + this.next_token)));
                result.add(new Integer(this.repository.addItem("!" + this.next_token)));
                if (endmark == "&") {
                    result.add(new Integer(this.repository.addItem("#" + this.next_token)));
                }
            } else {
                Debug.println(3, "CollectList: adding event name");
                result.add(new Integer(this.repository.addItem("?" + this.next_token + "^")));
                result.add(new Integer(this.repository.addItem("?" + this.next_token + "$")));
                result.add(new Integer(this.repository.addItem("!" + this.next_token + "^")));
                result.add(new Integer(this.repository.addItem("!" + this.next_token + "$")));
                if (endmark == "&") {
                    result.add(new Integer(this.repository.addItem("#" + this.next_token + "^")));
                    result.add(new Integer(this.repository.addItem("#" + this.next_token + "$")));
                }
            }
            this.next_token = this.nextToken();
            if (this.next_token == endmark) {
                Debug.println(2, "End mark reached ");
                this.next_token = this.nextToken();
                return result;
            }
            if (this.next_token.compareTo(",") != 0) {
                throw new SyntaxErrorException("Comma expected in list");
            }
            this.next_token = this.nextToken();
        }
        if (this.next_token == endmark) {
            Debug.println(2, "End mark reached");
            this.next_token = this.nextToken();
            return result;
        }
        throw new SyntaxErrorException("List syntax error");
    }

    private TreeNode restriction() throws SyntaxErrorException, IOException {
        int protstart = this.source.getIndex() - this.next_token.length() - 1;
        TreeNode result = this.alternative();
        while (this.next_token == "\\") {
            Debug.println(2, "Restriction found");
            this.next_token = this.nextToken();
            if (this.next_token != "(") {
                throw new SyntaxErrorException("Restriction list expected");
            }
            this.next_token = this.nextToken();
            TreeSet sync = this.collectList(")");
            Debug.println(2, "Restriction action tokens: " + sync.toString());
            result = new RestrictionNode(result, sync, this.repository);
            result.protocol = this.protocol.substring(protstart, this.source.getIndex() - this.next_token.length());
        }
        return result;
    }

    private TreeNode composition() throws SyntaxErrorException, IOException {
        int protstart = this.source.getIndex() - this.next_token.length() - 1;
        TreeNode node1 = this.restriction();
        while (this.next_token == "&") {
            Debug.println(2, "Composition found");
            this.next_token = this.nextToken();
            TreeSet sync = this.collectList("&");
            Debug.println(2, "Composition action tokens: " + sync.toString());
            TreeNode node2 = this.restriction();
            node1 = new CompositionNode(node1, node2, sync, this.repository);
            node1.protocol = this.protocol.substring(protstart, this.source.getIndex() - this.next_token.length());
        }
        return node1;
    }

    private TreeNode adjustment() throws SyntaxErrorException, IOException {
        int protstart = this.source.getIndex() - this.next_token.length() - 1;
        TreeNode node1 = this.composition();
        while (this.next_token == "@") {
            Debug.println(2, "Adjustment found");
            this.next_token = this.nextToken();
            TreeSet sync = this.collectList("@");
            Debug.println(2, "Adjustment action tokens: " + sync.toString());
            TreeNode node2 = this.composition();
            node1 = new AdjustmentNode(node1, node2, sync);
            node1.protocol = this.protocol.substring(protstart, this.source.getIndex() - this.next_token.length());
        }
        return node1;
    }

    private TreeNode term() throws SyntaxErrorException, IOException {
        int protstart = this.source.getIndex() - this.next_token.length() - 1;
        TreeNode result = this.factor();
        if (this.next_token == "*") {
            this.next_token = this.nextToken();
            result = new RepetitionNode(result);
            result.protocol = this.protocol.substring(protstart, this.source.getIndex() - this.next_token.length());
        }
        return result;
    }

    private TreeNode factor() throws SyntaxErrorException, IOException {
        TreeNode result;
        if (this.next_token.equals("NULL")) {
            result = new NullNode();
            result.protocol = "null";
            this.next_token = this.nextToken();
        } else if (this.next_token == "(") {
            this.next_token = this.nextToken();
            result = this.adjustment();
            if (this.next_token != ")") {
                throw new SyntaxErrorException(") expected");
            }
            this.next_token = this.nextToken();
        } else if (this.next_token == "[") {
            Debug.println(2, "Atomic action found");
            this.next_token = this.nextToken();
            TreeSet events = this.collectList("]");
            if (this.runtime) {
                TreeNode[] nodes = new TreeNode[events.size()];
                int i = 0;
                Iterator it = events.iterator();
                while (it.hasNext()) {
                    nodes[i] = new EventNode((Integer)it.next(), this.repository);
                    ++i;
                }
                result = new AndParallelNode(nodes);
            } else {
                result = new AtomicNode(this.repository.addAtomicItem(events), events, this.repository);
            }
        } else if (this.next_token.equals("")) {
            result = null;
        } else {
            int protstart = this.source.getIndex() - this.next_token.length() - 1;
            if (!this.isTokenID) {
                throw new SyntaxErrorException("identifier expected, last token " + this.next_token);
            }
            String event = this.next_token;
            this.next_token = this.nextToken();
            if (this.next_token == "{") {
                this.next_token = this.nextToken();
                TreeNode pom = this.alternative();
                if (this.next_token != "}") {
                    throw new SyntaxErrorException("} expected");
                }
                int protstop = this.source.getIndex() - this.next_token.length();
                this.next_token = this.nextToken();
                EventNode start = new EventNode(this.repository.addItem(event + "^"), this.repository);
                start.protocol = event + "^";
                String rev = Builder.getReverseAction(event);
                EventNode stop = new EventNode(this.repository.addItem(rev + "$"), this.repository);
                stop.protocol = rev + "$";
                TreeNode[] nodearray = new TreeNode[]{start, pom, stop};
                result = new SequenceNode(nodearray);
                result.protocol = this.protocol.substring(protstart, protstop);
                Debug.println(3, "Nested call abbreviation:");
            } else {
                EventNode a = new EventNode(this.repository.addItem(event), this.repository);
                if (Builder.isSimpleCall(event)) {
                    EventNode start = new EventNode(this.repository.addItem(event + "^"), this.repository);
                    start.protocol = event + "^";
                    EventNode stop = new EventNode(this.repository.addItem(Builder.getReverseAction(event + "$")), this.repository);
                    stop.protocol = Builder.getReverseAction(event + "$");
                    TreeNode[] nodearray = new TreeNode[]{start, stop};
                    result = new SequenceNode(nodearray);
                    result.protocol = event;
                } else {
                    result = a;
                    result.protocol = event;
                }
            }
        }
        return result;
    }

    public TreeNode build(ProtocolReader reader, boolean runtime) throws SyntaxErrorException {
        Debug.println(1, "Protocol Build: start");
        try {
            this.runtime = runtime;
            this.source = reader;
            this.protocol = new String();
            this.next_char = (char)this.source.read();
            if (this.next_char == '\uffffffff') {
                return null;
            }
            this.next_token = this.nextToken();
            TreeNode m = this.adjustment();
            if (this.next_token != "") {
                throw new SyntaxErrorException("Unexpected token: '" + this.next_token + "'.");
            }
            Debug.println(1, "Protocol Build: finished");
            return m;
        }
        catch (IOException e) {
            return null;
        }
    }
}

