/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.optimizer;

import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.node.AdjustmentNode;
import org.objectweb.fractal.bpc.checker.node.AndParallelNode;
import org.objectweb.fractal.bpc.checker.node.CompositionNode;
import org.objectweb.fractal.bpc.checker.node.ExplicitNode;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.Signature;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;

public class OptExplicit {
    private TreeNode node;
    private int threshold;

    public OptExplicit(TreeNode node, int threshold) {
        this.node = node;
        this.threshold = threshold;
    }

    public TreeNode perform() throws InvalidParameterException {
        Stack<Boolean> shouldbuild = new Stack<Boolean>();
        boolean buildflag = false;
        Stack<TreeNode> stack = new Stack<TreeNode>();
        int memoryleft = Options.totalmemory - Options.statememory;
        memoryleft *= 3000;
        stack.push(this.node);
        shouldbuild.push(new Boolean(buildflag));
        while (stack.size() > 0) {
            TreeNode actual = (TreeNode)stack.pop();
            buildflag = (Boolean)shouldbuild.pop();
            TreeNode[] children = actual.getChildren();
            if (actual instanceof AndParallelNode || actual instanceof AdjustmentNode || actual instanceof CompositionNode) {
                buildflag = true;
            }
            for (int i = 0; i < children.length; ++i) {
                long weight = children[i].getWeight();
                if (weight < (long)this.threshold && buildflag) {
                    children[i] = this.buildExplicit(children[i]);
                    this.threshold = (memoryleft = (int)((long)memoryleft - weight)) < this.threshold ? memoryleft : this.threshold;
                    continue;
                }
                stack.push(children[i]);
                shouldbuild.push(new Boolean(buildflag));
            }
        }
        Options.statememory += Signature.getSize() * memoryleft / 300000;
        return this.node;
    }

    private TreeNode buildExplicit(TreeNode node) throws InvalidParameterException {
        State actual;
        TreeMap<State, TransitionPair[]> restrans = new TreeMap<State, TransitionPair[]>();
        TreeSet<State> resaccept = new TreeSet<State>();
        TreeSet<State> visited = new TreeSet<State>();
        Stack<State> stack = new Stack<State>();
        State resinit = actual = node.getInitial();
        if (node.isAccepting(actual)) {
            resaccept.add(actual);
        }
        stack.push(actual);
        while (stack.size() > 0) {
            TransitionPair[] trans;
            actual = (State)stack.pop();
            actual.getSignature();
            if (visited.contains(actual)) continue;
            if (node.isAccepting(actual)) {
                resaccept.add(actual);
            }
            try {
                trans = node.getTransitions((State)actual).transitions;
            }
            catch (CheckingException e) {
                throw new RuntimeException("Internal checker error");
            }
            restrans.put(actual, trans);
            for (int i = 0; i < trans.length; ++i) {
                stack.push(trans[i].state);
            }
            visited.add(actual);
        }
        return new ExplicitNode(resinit, restrans, resaccept, node.protocol, node);
    }
}

