/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public abstract class TreeNode
implements Cloneable {
    protected TreeNode[] nodes;
    protected long weight;
    public String protocol;

    public TreeNode(String protocol) {
        this.protocol = protocol;
        this.weight = -1L;
    }

    public abstract long getWeight();

    public TreeNode[] getChildren() {
        return this.nodes;
    }

    public void changeChild(int index, TreeNode newChild) throws ArrayIndexOutOfBoundsException {
        this.nodes[index] = newChild;
    }

    public TreeNode forwardCut(TreeSet livingevents) {
        TreeNode active = null;
        int cnt = 0;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = this.nodes[i].forwardCut(livingevents);
            if (this.nodes[i] == null) continue;
            ++cnt;
            active = this.nodes[i];
        }
        if (cnt == 0) {
            return null;
        }
        if (cnt == 1 && this.nodes.length > 1) {
            return active;
        }
        if (this.nodes.length != cnt) {
            TreeNode[] newchildren = new TreeNode[cnt];
            int j = 0;
            for (int i = 0; i < cnt; ++i) {
                while (this.nodes[j] == null) {
                    ++j;
                }
                newchildren[i] = this.nodes[j++];
            }
            this.nodes = newchildren;
        }
        return this;
    }

    public TreeNode copy() {
        TreeNode newnode = null;
        try {
            newnode = (TreeNode)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        newnode.nodes = new TreeNode[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            newnode.nodes[i] = this.nodes[i].copy();
        }
        return newnode;
    }

    public int getLeafCount() {
        int cnt = 0;
        for (int i = 0; i < this.nodes.length; ++i) {
            cnt += this.nodes[i].getLeafCount();
        }
        return cnt;
    }

    public abstract AnotatedProtocol getAnotatedProtocol(State var1);

    public abstract State getInitial();

    public abstract boolean isAccepting(State var1);

    public abstract TransitionPairs getTransitions(State var1) throws InvalidParameterException, CheckingException;

    public abstract String[] getTypeName();
}

