/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.AlternativeNode;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.IndexState;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class SequenceNode
extends TreeNode {
    private int last;
    private State initial = null;

    public SequenceNode(TreeNode[] nodes) {
        super(SequenceNode.getProtocol(nodes));
        this.nodes = nodes;
        this.last = nodes.length - 1;
    }

    public State getInitial() {
        if (this.initial == null) {
            State[] states = new State[this.nodes.length];
            for (int i = 0; i < this.nodes.length; ++i) {
                states[i] = this.nodes[i].getInitial();
            }
            this.initial = new IndexState(0, states);
        }
        return this.initial;
    }

    public boolean isAccepting(State state) {
        IndexState istate = (IndexState)state;
        if (istate.index == this.last && this.nodes[this.last].isAccepting(istate.states[istate.index])) {
            return true;
        }
        if (this.nodes[istate.index].isAccepting(istate.states[istate.index])) {
            for (int i = istate.index + 1; i <= this.last; ++i) {
                if (this.nodes[i].isAccepting(this.nodes[i].getInitial())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException, CheckingException {
        IndexState istate = (IndexState)state;
        int stindex = istate.index;
        if (stindex != this.last && this.nodes[stindex].isAccepting(istate.states[stindex])) {
            ArrayList<TransitionPair[]> tmptrans = new ArrayList<TransitionPair[]>();
            TransitionPair[] atrans = this.nodes[stindex].getTransitions((State)istate.states[stindex]).transitions;
            int tmpindex = stindex;
            int bsize = 0;
            do {
                TransitionPair[] btrans = this.nodes[++tmpindex].getTransitions((State)this.nodes[tmpindex].getInitial()).transitions;
                tmptrans.add(btrans);
                bsize += btrans.length;
            } while (this.nodes[tmpindex].isAccepting(this.nodes[tmpindex].getInitial()) && tmpindex < this.last);
            int alen = atrans.length;
            int blen = bsize;
            TransitionPair[] trans = new TransitionPair[alen + blen];
            for (int i = 0; i < alen; ++i) {
                State[] tmpstates = new State[istate.states.length];
                for (int k = 0; k < istate.states.length; ++k) {
                    tmpstates[k] = istate.states[k];
                }
                tmpstates[stindex] = atrans[i].state;
                trans[i] = new TransitionPair(atrans[i].eventIndex, new IndexState(stindex, tmpstates));
            }
            int idx = alen;
            for (int j = 0; j < tmptrans.size(); ++j) {
                int i = 0;
                while (i < ((TransitionPair[])tmptrans.get(j)).length) {
                    State[] tmpstates = new State[istate.states.length];
                    for (int k = 0; k < istate.states.length; ++k) {
                        tmpstates[k] = k <= j && this.nodes[k] instanceof AlternativeNode ? ((AlternativeNode)this.nodes[k]).getAccepting() : istate.states[k];
                    }
                    TransitionPair current = ((TransitionPair[])tmptrans.get(j))[i];
                    tmpstates[stindex + 1 + j] = current.state;
                    trans[idx] = new TransitionPair(current.eventIndex, new IndexState(stindex + 1 + j, tmpstates));
                    ++i;
                    ++idx;
                }
            }
            return new TransitionPairs(trans);
        }
        TransitionPair[] atrans = this.nodes[stindex].getTransitions((State)istate.states[stindex]).transitions;
        int alen = atrans.length;
        TransitionPair[] trans = new TransitionPair[alen];
        for (int i = 0; i < alen; ++i) {
            State[] tmpstates = new State[istate.states.length];
            for (int k = 0; k < istate.states.length; ++k) {
                tmpstates[k] = istate.states[k];
            }
            tmpstates[stindex] = atrans[i].state;
            trans[i] = new TransitionPair(atrans[i].eventIndex, new IndexState(stindex, tmpstates));
        }
        return new TransitionPairs(trans);
    }

    public long getWeight() {
        if (this.weight != -1L) {
            return this.weight;
        }
        this.weight = 0L;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.weight += this.nodes[i].getWeight() - 1L;
        }
        return this.weight + 1L;
    }

    public TreeNode forwardCut(TreeSet livingevents) {
        TreeNode active = null;
        int cnt = 0;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = this.nodes[i].forwardCut(livingevents);
            if (this.nodes[i] == null) continue;
            ++cnt;
            active = this.nodes[i];
        }
        if (cnt == 0) {
            return null;
        }
        if (cnt == 1 && this.nodes.length > 1) {
            return active;
        }
        if (this.nodes.length != cnt) {
            TreeNode[] newchildren = new TreeNode[cnt];
            int j = 0;
            for (int i = 0; i < cnt; ++i) {
                while (this.nodes[j] == null) {
                    ++j;
                }
                newchildren[i] = this.nodes[j++];
            }
            this.nodes = newchildren;
            this.last = this.nodes.length - 1;
        }
        return this;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"Sequence", ";"};
        return result;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        IndexState istate = (IndexState)state;
        int nodecnt = this.nodes.length;
        String result = new String();
        ArrayList<Integer> indicesresult = new ArrayList<Integer>();
        for (int i = 0; i < nodecnt; ++i) {
            AnotatedProtocol subresult = this.nodes[i].getAnotatedProtocol(istate != null && istate.index == i ? istate.states[i] : null);
            for (int j = 0; j < subresult.indices.size(); ++j) {
                indicesresult.add(new Integer((Integer)subresult.indices.get(j) + result.length()));
            }
            result = result + subresult.protocol;
            if (i >= nodecnt - 1) continue;
            result = result + "; ";
        }
        return new AnotatedProtocol(result, indicesresult);
    }

    private static String getProtocol(TreeNode[] nodes) {
        String result = new String();
        result = "(" + nodes[0].protocol + ")";
        for (int i = 1; i < nodes.length; ++i) {
            result = result + "; (" + nodes[i].protocol + ")";
        }
        return result;
    }
}

