/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class RestrictionNode
extends TreeNode {
    private final TreeSet restriction;

    public RestrictionNode(TreeNode node, TreeSet restriction, ActionRepository repository) {
        super("(" + node.protocol + ")\\\\{" + RestrictionNode.getRestr(restriction, repository) + "}");
        this.restriction = restriction;
        this.nodes = new TreeNode[1];
        this.nodes[0] = node;
    }

    public State getInitial() {
        return this.nodes[0].getInitial();
    }

    public boolean isAccepting(State state) {
        if (this.nodes[0].isAccepting(state)) {
            return true;
        }
        try {
            return this.getAccepting(state);
        }
        catch (InvalidParameterException e) {
            System.out.println("!!!! Exception while processing RestrictionNode::getAccepting() !!!!\n");
            System.exit(1);
            return false;
        }
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException, CheckingException {
        int i;
        Stack<State> stack = new Stack<State>();
        TreeSet<State> processed = new TreeSet<State>();
        ArrayList<TransitionPair> result = new ArrayList<TransitionPair>();
        stack.push(state);
        while (stack.size() > 0) {
            State actual = (State)stack.pop();
            if (processed.contains(actual)) continue;
            TransitionPair[] trans = this.nodes[0].getTransitions((State)actual).transitions;
            for (i = 0; i < trans.length; ++i) {
                Integer evindex = new Integer(trans[i].eventIndex);
                boolean restricted = this.restriction.contains(new Integer(ActionRepository.getPure(evindex)));
                if (restricted) {
                    result.add(trans[i]);
                    continue;
                }
                stack.push(trans[i].state);
            }
            processed.add(actual);
        }
        TransitionPair[] result1 = new TransitionPair[result.size()];
        Iterator it = result.iterator();
        i = 0;
        while (it.hasNext()) {
            result1[i++] = (TransitionPair)it.next();
        }
        return new TransitionPairs(result1);
    }

    private boolean getAccepting(State state) throws InvalidParameterException {
        Stack<State> stack = new Stack<State>();
        TreeSet<State> processed = new TreeSet<State>();
        stack.push(state);
        while (stack.size() > 0) {
            State actual = (State)stack.pop();
            TransitionPair[] trans = null;
            try {
                trans = this.nodes[0].getTransitions((State)actual).transitions;
            }
            catch (CheckingException e) {
                throw new RuntimeException("Internal error error");
            }
            for (int i = 0; i < trans.length; ++i) {
                if (this.restriction.contains(new Integer(ActionRepository.getPure(trans[i].eventIndex)))) continue;
                if (this.nodes[0].isAccepting(trans[i].state)) {
                    return true;
                }
                if (processed.contains(trans[i].state)) continue;
                stack.push(trans[i].state);
            }
            processed.add(actual);
        }
        return false;
    }

    public long getWeight() {
        if (this.weight != -1L) {
            return this.weight;
        }
        this.weight = this.nodes[0].getWeight();
        return this.weight;
    }

    public TreeNode forwardCut(TreeSet livingevents) {
        TreeSet<Integer> exlivev = new TreeSet<Integer>();
        Iterator it = livingevents.iterator();
        while (it.hasNext()) {
            Integer event = (Integer)it.next();
            if (!this.restriction.contains(new Integer(ActionRepository.getPure(event)))) continue;
            exlivev.add(event);
        }
        this.nodes[0] = this.nodes[0].forwardCut(exlivev);
        if (this.nodes[0] == null) {
            return null;
        }
        return this;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"Restriction", "\\\\"};
        return result;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        return this.nodes[0].getAnotatedProtocol(state);
    }

    private static String getRestr(TreeSet restriction, ActionRepository repository) {
        String result = new String();
        Iterator it = restriction.iterator();
        result = repository.getItemString((Integer)it.next());
        while (it.hasNext()) {
            result = result + ", " + repository.getItemString((Integer)it.next());
        }
        return result;
    }
}

