/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class RepetitionNode
extends TreeNode {
    private State initial;
    public String probRepeat;
    public String probExit;

    public RepetitionNode(TreeNode node) {
        super("(" + node.protocol + ")*");
        this.nodes = new TreeNode[1];
        this.nodes[0] = node;
        this.initial = null;
    }

    public State getInitial() {
        if (this.initial == null) {
            this.initial = this.nodes[0].getInitial();
        }
        return this.initial;
    }

    public boolean isAccepting(State state) {
        return this.initial.equals(state) || this.nodes[0].isAccepting(state);
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException, CheckingException {
        State initial = this.nodes[0].getInitial();
        TransitionPair[] origtrans = this.nodes[0].getTransitions((State)state).transitions;
        int transcnt = origtrans.length;
        if (this.nodes[0].isAccepting(state)) {
            int i;
            initial = this.nodes[0].getInitial();
            TransitionPair[] trans = this.nodes[0].getTransitions((State)initial).transitions;
            TransitionPair[] result = new TransitionPair[trans.length + transcnt];
            for (i = 0; i < transcnt; ++i) {
                result[i] = origtrans[i];
            }
            for (i = 0; i < trans.length; ++i) {
                result[i + transcnt] = trans[i];
            }
            return new TransitionPairs(result);
        }
        return new TransitionPairs(origtrans);
    }

    public long getWeight() {
        if (this.weight != -1L) {
            return this.weight;
        }
        this.weight = this.nodes[0].getWeight();
        return this.weight;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"Repetition", "*"};
        return result;
    }

    public TreeNode forwardCut(TreeSet livingevents) {
        this.nodes[0] = this.nodes[0].forwardCut(livingevents);
        if (this.nodes[0] != null) {
            if (this.nodes[0] instanceof RepetitionNode) {
                return this.nodes[0];
            }
            return this;
        }
        return null;
    }

    public int getLeafCount() {
        return this.nodes[0].getLeafCount() * 2;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        String result = new String();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        result = "(";
        AnotatedProtocol subresult = this.nodes[0].getAnotatedProtocol(state);
        for (int i = 0; i < subresult.indices.size(); ++i) {
            indices.add(new Integer((Integer)subresult.indices.get(i) + result.length()));
        }
        result = result + subresult.protocol + ")*";
        return new AnotatedProtocol(result, indices);
    }
}

