/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.TreeMap;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class ExplicitNode
extends TreeNode {
    private final State initial;
    private TreeNode original;
    private final TreeMap transitions;
    private final TreeSet accepting;

    public ExplicitNode(State initial, TreeMap transitions, TreeSet accepting, String protocol, TreeNode original) {
        super(protocol);
        this.initial = initial;
        this.transitions = transitions;
        this.accepting = accepting;
        this.nodes = new TreeNode[0];
        this.original = original;
        this.weight = 1L;
    }

    public State getInitial() {
        return this.initial;
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException {
        TransitionPair[] result = (TransitionPair[])this.transitions.get(state);
        if (result != null) {
            return new TransitionPairs(result);
        }
        return new TransitionPairs(new TransitionPair[0]);
    }

    public boolean isAccepting(State state) {
        return this.accepting.contains(state);
    }

    public long getWeight() {
        return 1L;
    }

    public TreeNode forwardCut(TreeSet livingevents) {
        return this;
    }

    public TreeNode copy() {
        return this;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"Explicit", "EXPLICIT"};
        return result;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        return this.original.getAnotatedProtocol(state);
    }
}

