/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.SimpleState;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;
import org.objectweb.fractal.bpc.checker.utils.ProtocolUsageMonitor;

public class EventNode
extends TreeNode {
    private final int eventIndex;
    private SimpleState initState;
    private final TransitionPairs initTransitions;
    private final TransitionPairs secondTransitions;
    private boolean executed;
    public String probExec = null;

    public EventNode(int eventindex, ActionRepository repository) {
        super(repository.getItemString(eventindex));
        this.eventIndex = eventindex;
        this.initState = new SimpleState(0);
        this.initTransitions = new TransitionPairs(new TransitionPair[1]);
        this.initTransitions.transitions[0] = new TransitionPair(eventindex, new SimpleState(1));
        this.secondTransitions = new TransitionPairs(new TransitionPair[0]);
        this.nodes = new TreeNode[0];
        this.weight = 2L;
        this.executed = false;
    }

    public State getInitial() {
        return this.initState;
    }

    public boolean isAccepting(State state) {
        return ((SimpleState)state).state == 1;
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException {
        if (((SimpleState)state).state == 0) {
            if (Options.monitorusage) {
                ProtocolUsageMonitor.eventGenerated(this.eventIndex, this);
            }
            return this.initTransitions;
        }
        if (((SimpleState)state).state == 1) {
            return this.secondTransitions;
        }
        throw new InvalidParameterException();
    }

    public long getWeight() {
        return 2L;
    }

    public TreeNode forwardCut(TreeSet livingevents) {
        if (livingevents.contains(new Integer(this.eventIndex))) {
            return this;
        }
        return null;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"Event", ""};
        return result;
    }

    public int getEventIndex() {
        return this.eventIndex;
    }

    public int getLeafCount() {
        return 1;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        String result = new String();
        ArrayList<Integer> indicesresult = new ArrayList<Integer>();
        result = this.protocol;
        if (state != null) {
            if (((SimpleState)state).state == 0) {
                indicesresult.add(new Integer(0));
            } else {
                indicesresult.add(new Integer(result.length()));
            }
        }
        return new AnotatedProtocol(result, indicesresult);
    }

    public void setExecuted() {
        this.executed = true;
    }

    public boolean getExecuted() {
        return this.executed;
    }
}

