/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.CompositeState;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class DeterministicNode
extends TreeNode {
    public DeterministicNode(TreeNode node) {
        super("Det(" + node.protocol + ")");
        this.nodes = new TreeNode[1];
        this.nodes[0] = node;
    }

    public State getInitial() {
        State[] state = new State[]{this.nodes[0].getInitial()};
        return new CompositeState(state);
    }

    public boolean isAccepting(State state) {
        CompositeState cstate = (CompositeState)state;
        for (int i = 0; i < cstate.states.length; ++i) {
            if (!this.nodes[0].isAccepting(cstate.states[i])) continue;
            return true;
        }
        return false;
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException, CheckingException {
        CompositeState cstate = (CompositeState)state;
        TreeMap<Integer, TreeSet<State>> transmap = new TreeMap<Integer, TreeSet<State>>();
        LinkedList deps = new LinkedList();
        int nodecnt = cstate.states.length;
        for (int i = 0; i < nodecnt; ++i) {
            TransitionPairs transp = this.nodes[0].getTransitions(cstate.states[i]);
            TransitionPair[] trans = transp.transitions;
            if (transp.deps != null) {
                deps.addAll(transp.deps);
            }
            for (int j = 0; j < trans.length; ++j) {
                TreeSet<State> states = (TreeSet<State>)transmap.get(new Integer(trans[j].eventIndex));
                if (states != null) {
                    states.add(trans[j].state);
                    continue;
                }
                states = new TreeSet<State>();
                states.add(trans[j].state);
                transmap.put(new Integer(trans[j].eventIndex), states);
            }
        }
        TransitionPair[] result = new TransitionPair[transmap.size()];
        Set keys = transmap.keySet();
        Iterator it = keys.iterator();
        int i = 0;
        while (it.hasNext()) {
            Integer eventindex = (Integer)it.next();
            TreeSet states = (TreeSet)transmap.get(eventindex);
            State[] resultstates = new State[states.size()];
            Iterator it2 = states.iterator();
            int l = 0;
            while (it2.hasNext()) {
                resultstates[l++] = (State)it2.next();
            }
            result[i++] = new TransitionPair(eventindex, new CompositeState(resultstates));
        }
        TransitionPairs restrans = new TransitionPairs(result);
        restrans.deps = deps;
        return restrans;
    }

    public long getWeight() {
        if (this.weight != -1L) {
            return this.weight;
        }
        this.weight = this.nodes[0].getWeight();
        return this.weight;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"Deterministic", "DET"};
        return result;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        CompositeState cstate = (CompositeState)state;
        String result = new String();
        int cnt = cstate != null ? cstate.states.length : 0;
        ArrayList<Integer> indicesresult = new ArrayList<Integer>();
        for (int i = 0; i < cnt; ++i) {
            AnotatedProtocol subresult = this.nodes[0].getAnotatedProtocol(cstate.states[i]);
            for (int j = 0; j < subresult.indices.size(); ++j) {
                indicesresult.add(new Integer((Integer)subresult.indices.get(j) + result.length()));
            }
        }
        result = this.nodes[0].getAnotatedProtocol(null).protocol;
        return new AnotatedProtocol(result, indicesresult);
    }
}

