/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.BadActivityException;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.DFSR.NoActivityException;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.AtomicAction;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.NullNode;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.CompositeState;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class ConsentNode
extends TreeNode {
    private final TreeSet events;
    private final TreeSet unboundEvents;
    private ActionRepository repository;
    private boolean topmost;
    private boolean test;
    private TreeSet boundEvents;
    private boolean[][] boundAtomicActions;
    private LinkedList[] dependecies;
    private LinkedList currentdeps;
    private HashMap delayed;

    public ConsentNode(TreeNode node1, TreeNode node2, TreeSet events, TreeSet unboundEvents, ActionRepository repository, boolean test) {
        super("(" + node1.protocol + ")%(" + node2.protocol + ")");
        this.events = events;
        this.unboundEvents = unboundEvents;
        this.repository = repository;
        this.topmost = true;
        this.test = test;
        this.nodes = new TreeNode[2];
        this.nodes[0] = node1;
        this.nodes[1] = node2;
        if (node1 instanceof ConsentNode) {
            ((ConsentNode)node1).topmost = false;
        }
        if (node2 instanceof ConsentNode) {
            ((ConsentNode)node2).topmost = false;
        }
        this.boundEvents = new TreeSet();
        this.boundAtomicActions = new boolean[2][];
        this.dependecies = new LinkedList[2];
        this.delayed = new HashMap();
    }

    public long getWeight() {
        if (this.weight != -1L) {
            return this.weight;
        }
        long w1 = this.nodes[0].getWeight();
        long w2 = this.nodes[1].getWeight();
        this.weight = (long)(0.5f * (float)w1 * (float)w2 + 0.25f * (float)((w1 + w2) / 2L));
        return this.weight;
    }

    public State getInitial() {
        State[] states = new State[]{this.nodes[0].getInitial(), this.nodes[1].getInitial()};
        return new CompositeState(states);
    }

    public boolean isAccepting(State state) {
        CompositeState cstate = (CompositeState)state;
        return this.nodes[0].isAccepting(cstate.states[0]) && this.nodes[1].isAccepting(cstate.states[1]);
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException, CheckingException {
        Integer key;
        int i;
        CompositeState cstate = (CompositeState)state;
        this.delayed.clear();
        TransitionPairs transp1 = this.nodes[0].getTransitions(cstate.states[0]);
        TransitionPairs transp2 = this.nodes[1].getTransitions(cstate.states[1]);
        TransitionPair[] trans1 = transp1.transitions;
        TransitionPair[] trans2 = transp2.transitions;
        this.currentdeps = new LinkedList();
        this.dependecies[0] = transp1.deps;
        this.dependecies[1] = transp2.deps;
        ArrayList<TransitionPair> result = new ArrayList<TransitionPair>();
        TreeMap<Integer, TransitionPair> sync = new TreeMap<Integer, TransitionPair>();
        this.boundAtomicActions[0] = new boolean[trans1.length];
        this.boundAtomicActions[1] = new boolean[trans2.length];
        for (i = 0; i < trans1.length; ++i) {
            key = new Integer(trans1[i].eventIndex);
            if (key < 0) {
                if (!this.makeAtomicTransition(i, trans1, trans2, cstate, result, 0)) continue;
                this.boundAtomicActions[0][i] = true;
                continue;
            }
            if (this.events.contains(new Integer(ActionRepository.getPure(trans1[i].eventIndex)))) {
                sync.put(new Integer(trans1[i].eventIndex), trans1[i]);
                Iterator it = this.currentdeps.iterator();
                while (it.hasNext()) {
                    TransitionPairs.IntPair item = (TransitionPairs.IntPair)it.next();
                    if (item.second != trans1[i].eventIndex) continue;
                    it.remove();
                }
                this.delayed.put(key, null);
                continue;
            }
            if (this.topmost && this.unboundEvents.contains(new Integer(ActionRepository.getPure(trans1[i].eventIndex)))) {
                boolean isResponse = this.repository.isResponse(trans1[i].eventIndex);
                if (!Options.badactivity || !this.test || isResponse) continue;
                throw new BadActivityException("missing binding for request '" + this.repository.getItemString(trans2[i].eventIndex) + "':");
            }
            State[] states = new State[]{trans1[i].state, cstate.states[1]};
            result.add(new TransitionPair(trans1[i].eventIndex, new CompositeState(states)));
        }
        this.boundEvents.clear();
        this.boundEvents.addAll(sync.keySet());
        for (i = 0; i < trans2.length; ++i) {
            key = new Integer(trans2[i].eventIndex);
            if (key < 0) {
                if (this.boundAtomicActions[1][i] || !this.makeAtomicTransition(i, trans2, trans1, cstate, result, 1)) continue;
                this.boundEvents.removeAll(this.repository.getAtomicEvents(this.repository.getInverseAction(trans2[i].eventIndex)));
                continue;
            }
            if (this.events.contains(new Integer(ActionRepository.getPure(trans2[i].eventIndex)))) {
                Integer invkey = new Integer(this.repository.getInverseAction(trans2[i].eventIndex));
                if (sync.containsKey(invkey)) {
                    State[] states = new State[]{((TransitionPair)sync.get((Object)invkey)).state, trans2[i].state};
                    result.add(new TransitionPair(this.repository.getTauAction(trans2[i].eventIndex), new CompositeState(states)));
                    Iterator it = this.currentdeps.iterator();
                    while (it.hasNext()) {
                        TransitionPairs.IntPair item = (TransitionPairs.IntPair)it.next();
                        if (item.second != trans2[i].eventIndex) continue;
                        it.remove();
                    }
                    this.boundEvents.remove(invkey);
                    this.delayed.put(key, null);
                } else {
                    boolean isResponse = this.repository.isResponse(trans2[i].eventIndex);
                    if (Options.badactivity && this.test && !isResponse && !this.boundAtomicActions[1][i] && !this.unboundEvents.contains(new Integer(ActionRepository.getPure(trans2[i].eventIndex)))) {
                        throw new BadActivityException("bad activity(" + this.repository.getItemString(trans2[i].eventIndex) + "):");
                    }
                }
                if (!this.topmost || !this.test || !this.unboundEvents.contains(new Integer(ActionRepository.getPure(trans2[i].eventIndex))) || this.repository.isResponse(trans2[i].eventIndex)) continue;
                throw new BadActivityException("missing binding for request '" + this.repository.getItemString(trans2[i].eventIndex) + "':");
            }
            if (this.topmost && this.unboundEvents.contains(new Integer(ActionRepository.getPure(trans2[i].eventIndex)))) {
                boolean isResponse = this.repository.isResponse(trans2[i].eventIndex);
                if (!Options.badactivity || !this.test || isResponse) continue;
                throw new BadActivityException("missing binding for request '" + this.repository.getItemString(trans2[i].eventIndex) + "':");
            }
            State[] states = new State[]{cstate.states[0], trans2[i].state};
            result.add(new TransitionPair(trans2[i].eventIndex, new CompositeState(states)));
        }
        Iterator it = this.boundEvents.iterator();
        while (it.hasNext()) {
            int action = (Integer)it.next();
            if (!Options.badactivity || !this.test || this.repository.isResponse(action)) continue;
            throw new BadActivityException("bad activity (" + this.repository.getItemString(action) + "):");
        }
        Iterator it2 = this.delayed.keySet().iterator();
        while (it2.hasNext()) {
            TransitionPairs.IntPair data = (TransitionPairs.IntPair)this.delayed.get(it2.next());
            if (data == null) continue;
            throw new BadActivityException("Bad activity (atomic action " + this.repository.getItemString(data.first) + " cannot accept " + this.repository.getItemString(this.repository.getInverseAction(data.second)) + "). Trace: ");
        }
        if (this.topmost) {
            Iterator it3 = result.iterator();
            while (it3.hasNext()) {
                if (!this.unboundEvents.contains(new Integer(ActionRepository.getPure(((TransitionPair)it3.next()).eventIndex)))) continue;
                it3.remove();
            }
        }
        TransitionPair[] result1 = new TransitionPair[result.size()];
        Iterator it22 = result.iterator();
        int i2 = 0;
        while (it22.hasNext()) {
            result1[i2++] = (TransitionPair)it22.next();
        }
        if (result1.length == 0 && Options.noactivity && this.test && !this.isAccepting(state)) {
            throw new NoActivityException("no activity:");
        }
        if (this.topmost) {
            for (int j = 0; j < result1.length; ++j) {
                if (result1[j].eventIndex >= 0) continue;
                Iterator itt = this.currentdeps.iterator();
                while (itt.hasNext()) {
                    TransitionPairs.IntPair item = (TransitionPairs.IntPair)itt.next();
                    if (item.first != result1[j].eventIndex) continue;
                    throw new BadActivityException("Atomic action " + this.repository.getItemString(item.first) + " raised a bad activity exception. Trace:");
                }
            }
        }
        return new TransitionPairs(result1, this.currentdeps);
    }

    private boolean makeAtomicTransition(int index, TransitionPair[] first, TransitionPair[] second, CompositeState starting, ArrayList result, int tooglebit) throws BadActivityException {
        LinkedList trans = this.makeTransition(index, first, second, starting, tooglebit);
        if (trans.size() > 0) {
            result.addAll(trans);
            return true;
        }
        return false;
    }

    private LinkedList makeTransition(int index, TransitionPair[] first, TransitionPair[] second, CompositeState starting, int tooglebit) {
        int atomicactionindex = first[index].eventIndex;
        AtomicAction aaction = this.repository.getAtomicEvents(atomicactionindex);
        AtomicAction synchroaction = new AtomicAction();
        LinkedList<TransitionPair> result = new LinkedList<TransitionPair>();
        LinkedList<Integer> nosynchro = new LinkedList<Integer>();
        boolean bound = false;
        AtomicAction newaa = null;
        Iterator it = aaction.iterator();
        while (it.hasNext()) {
            Integer event = (Integer)it.next();
            if (this.events.contains(new Integer(ActionRepository.getPure(event)))) {
                synchroaction.add(event);
                continue;
            }
            nosynchro.add(event);
        }
        if (synchroaction.size() == 0) {
            State[] states = new State[2];
            states[tooglebit] = first[index].state;
            states[1 - tooglebit] = starting.states[1 - tooglebit];
            result.add(new TransitionPair(first[index].eventIndex, new CompositeState(states)));
            Iterator it2 = this.dependecies[tooglebit].iterator();
            while (it2.hasNext()) {
                TransitionPairs.IntPair item = (TransitionPairs.IntPair)it2.next();
                if (item.first != first[index].eventIndex) continue;
                this.currentdeps.add(item);
            }
            return result;
        }
        if (synchroaction.size() == 1) {
            int synchroactionidx = (Integer)synchroaction.first();
            for (int i = 0; i < second.length; ++i) {
                if (tooglebit == 1 && this.boundAtomicActions[0][i]) continue;
                if (second[i].eventIndex >= 0) {
                    if (synchroactionidx == this.repository.getInverseAction(second[i].eventIndex)) {
                        newaa = new AtomicAction((Collection)aaction);
                        newaa.remove(new Integer(synchroactionidx));
                        newaa.add(new Integer(this.repository.getTauAction(synchroactionidx)));
                        State[] states = new State[2];
                        states[tooglebit] = first[index].state;
                        states[1 - tooglebit] = second[i].state;
                        result.add(new TransitionPair(this.repository.getItemIndex(newaa), new CompositeState(states)));
                        this.boundAtomicActions[1 - tooglebit][i] = true;
                        bound = true;
                        continue;
                    }
                    if (!this.repository.isResponse(synchroactionidx)) continue;
                    this.currentdeps.add(new TransitionPairs.IntPair(first[index].eventIndex, second[i].eventIndex));
                    continue;
                }
                newaa = new AtomicAction((Collection)this.repository.getAtomicEvents(second[i].eventIndex));
                boolean was = newaa.remove(new Integer(this.repository.getInverseAction(synchroactionidx)));
                if (!was) continue;
                newaa.add(new Integer(this.repository.getTauAction(synchroactionidx)));
                State[] states = new State[2];
                states[tooglebit] = first[index].state;
                states[1 - tooglebit] = second[i].state;
                result.add(new TransitionPair(this.repository.getItemIndex(newaa), new CompositeState(states)));
                bound = true;
                this.boundAtomicActions[1 - tooglebit][i] = true;
            }
            if (!bound) {
                if (this.repository.isResponse(synchroactionidx)) {
                    Iterator iterator = this.currentdeps.iterator();
                    while (iterator.hasNext()) {
                        TransitionPairs.IntPair item = (TransitionPairs.IntPair)iterator.next();
                        if (item.first != first[index].eventIndex) continue;
                        if (this.repository.isResponse(item.second)) {
                            if (this.delayed.containsKey(new Integer(item.second))) continue;
                            this.delayed.put(new Integer(item.second), item);
                            continue;
                        }
                        iterator.remove();
                        this.delayed.put(new Integer(item.second), null);
                    }
                    return result;
                }
                Iterator it2 = this.dependecies[tooglebit].iterator();
                while (it2.hasNext()) {
                    TransitionPairs.IntPair item = (TransitionPairs.IntPair)it2.next();
                    if (item.first != first[index].eventIndex) continue;
                    item.first = this.repository.getItemIndex(newaa);
                    this.currentdeps.add(item);
                }
                result.add(new TransitionPair(first[index].eventIndex, null));
                this.currentdeps.add(new TransitionPairs.IntPair(first[index].eventIndex, synchroactionidx));
                return result;
            }
            return result;
        }
        TreeSet<TransitionPairs.IntPair> atomiccandidates = new TreeSet<TransitionPairs.IntPair>();
        TreeSet<TransitionPairs.IntPair> newcandidates = new TreeSet<TransitionPairs.IntPair>();
        for (int i = 0; i < second.length; ++i) {
            if (second[i].eventIndex >= 0) continue;
            atomiccandidates.add(new TransitionPairs.IntPair(second[i].eventIndex, i));
        }
        it = atomiccandidates.iterator();
        while (it.hasNext()) {
            TransitionPairs.IntPair pair = (TransitionPairs.IntPair)it.next();
            AtomicAction aa = new AtomicAction((Collection)this.repository.getAtomicEvents(pair.first));
            int secondindex = pair.second;
            boolean bound2 = false;
            Iterator it2 = synchroaction.iterator();
            while (it2.hasNext()) {
                Integer event = (Integer)it2.next();
                boolean was = aa.remove(new Integer(this.repository.getInverseAction(event)));
                if (was) {
                    int tauaction = this.repository.getTauAction(event);
                    aa.add(new Integer(tauaction));
                    bound2 = true;
                    continue;
                }
                bound2 = false;
                break;
            }
            if (!bound2) continue;
            newcandidates.add(new TransitionPairs.IntPair(this.repository.getItemIndex(aa), secondindex));
            this.boundAtomicActions[1 - tooglebit][secondindex] = true;
        }
        boolean containsresponse = false;
        if (newcandidates.size() == 0) {
            it = synchroaction.iterator();
            while (it.hasNext()) {
                if (!this.repository.isResponse((Integer)it.next())) continue;
                containsresponse = true;
                break;
            }
            if (containsresponse) {
                Iterator iterator = this.currentdeps.iterator();
                while (iterator.hasNext()) {
                    TransitionPairs.IntPair item = (TransitionPairs.IntPair)iterator.next();
                    if (item.first != first[index].eventIndex) continue;
                    if (this.repository.isResponse(item.second)) {
                        if (this.delayed.containsKey(new Integer(item.second))) continue;
                        this.delayed.put(new Integer(item.second), item);
                        continue;
                    }
                    iterator.remove();
                    this.delayed.put(new Integer(item.second), null);
                }
                return result;
            }
            Iterator it2 = this.dependecies[tooglebit].iterator();
            while (it2.hasNext()) {
                TransitionPairs.IntPair item = (TransitionPairs.IntPair)it2.next();
                if (item.first != first[index].eventIndex) continue;
                item.first = this.repository.getItemIndex(newaa);
                this.currentdeps.add(item);
            }
            result.add(new TransitionPair(first[index].eventIndex, null));
            this.currentdeps.add(new TransitionPairs.IntPair(first[index].eventIndex, (Integer)synchroaction.first()));
            return result;
        }
        it = newcandidates.iterator();
        while (it.hasNext()) {
            TransitionPairs.IntPair pair = (TransitionPairs.IntPair)it.next();
            State[] states = new State[]{first[index].state, second[pair.second].state};
            AtomicAction aa1 = this.repository.getAtomicEvents(pair.first);
            AtomicAction aa2 = this.repository.getAtomicEvents(second[pair.second].eventIndex);
            Iterator it2 = aa2.iterator();
            while (it2.hasNext()) {
                int idx = (Integer)it2.next();
                if (aa1.contains(new Integer(this.repository.getInverseAction(idx))) || aa1.contains(new Integer(this.repository.getTauAction(idx)))) continue;
                aa1.add(new Integer(idx));
            }
            result.add(new TransitionPair(this.repository.getItemIndex(aa1), new CompositeState(states)));
        }
        return result;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"Consent", "%"};
        return result;
    }

    public TreeNode forwardCut(TreeSet livingevents) {
        TreeSet exlivev = new TreeSet(livingevents);
        exlivev.addAll(this.events);
        TreeSet exlivev2 = new TreeSet(exlivev);
        this.nodes[0] = this.nodes[0].forwardCut(exlivev);
        this.nodes[1] = this.nodes[1].forwardCut(exlivev2);
        if (this.nodes[0] == null) {
            this.nodes[0] = new NullNode();
        }
        if (this.nodes[1] == null) {
            this.nodes[1] = new NullNode();
        }
        return this;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        CompositeState cstate = (CompositeState)state;
        int nodecnt = this.nodes.length;
        String result = new String();
        ArrayList<Integer> indicesresult = new ArrayList<Integer>();
        for (int i = 0; i < nodecnt; ++i) {
            AnotatedProtocol subresult = this.nodes[i].getAnotatedProtocol(cstate != null ? cstate.states[i] : null);
            for (int j = 0; j < subresult.indices.size(); ++j) {
                indicesresult.add(new Integer((Integer)subresult.indices.get(j) + result.length()));
            }
            result = result + subresult.protocol;
            if (i >= nodecnt - 1) continue;
            result = result + " % ";
        }
        return new AnotatedProtocol(result, indicesresult);
    }
}

