/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.SimpleState;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class AtomicNode
extends TreeNode {
    private int eventIndex;
    private SimpleState initState;
    private final TransitionPairs initTransitions;
    private final TransitionPairs secondTransitions;

    public AtomicNode(int eventindex, TreeSet events, ActionRepository repository) {
        super(AtomicNode.getProtocol(events, repository));
        this.eventIndex = eventindex;
        this.initState = null;
        this.initTransitions = new TransitionPairs(new TransitionPair[1]);
        this.initTransitions.transitions[0] = null;
        this.secondTransitions = new TransitionPairs(new TransitionPair[0]);
        this.nodes = new TreeNode[0];
        this.weight = 2L;
    }

    public AtomicNode(int eventindex, ActionRepository repository) {
        this(eventindex, repository.getAtomicEvents(eventindex), repository);
    }

    public long getWeight() {
        return 2L;
    }

    public State getInitial() {
        if (this.initState == null) {
            this.initState = new SimpleState(0);
            this.initTransitions.transitions[0] = new TransitionPair(this.eventIndex, new SimpleState(1));
        }
        return this.initState;
    }

    public boolean isAccepting(State state) {
        return ((SimpleState)state).state == 1;
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException, CheckingException {
        if (((SimpleState)state).state == 0) {
            return this.initTransitions;
        }
        if (((SimpleState)state).state == 1) {
            return this.secondTransitions;
        }
        throw new InvalidParameterException();
    }

    public String[] getTypeName() {
        String[] result = new String[]{"AtomicAction", "atomic action"};
        return result;
    }

    public TreeNode forwardCut(TreeSet livingevents) {
        return this;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        String result = new String();
        ArrayList<Integer> indicesresult = new ArrayList<Integer>();
        result = this.protocol;
        if (state != null) {
            if (((SimpleState)state).state == 0) {
                indicesresult.add(new Integer(0));
            } else {
                indicesresult.add(new Integer(result.length()));
            }
        }
        return new AnotatedProtocol(result, indicesresult);
    }

    public int getEventIndex() {
        return this.eventIndex;
    }

    private static String getProtocol(TreeSet events, ActionRepository repository) {
        String p = new String();
        Iterator it = events.iterator();
        p = repository.getItemString((Integer)it.next());
        while (it.hasNext()) {
            p = p + ", " + repository.getItemString((Integer)it.next());
        }
        p = "[" + p + "]";
        return p;
    }
}

