/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.CompositeState;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class AndParallelNode
extends TreeNode {
    public AndParallelNode(TreeNode[] nodes) {
        super(AndParallelNode.getProtocol(nodes));
        this.nodes = nodes;
    }

    public State getInitial() {
        State[] init = new State[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            init[i] = this.nodes[i].getInitial();
        }
        return new CompositeState(init);
    }

    public boolean isAccepting(State state) {
        State[] states = ((CompositeState)state).states;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].isAccepting(states[i])) continue;
            return false;
        }
        return true;
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException, CheckingException {
        int i;
        CompositeState cstate = (CompositeState)state;
        int statecnt = cstate.states.length;
        int totalcnt = 0;
        TransitionPair[][] transmatrix = new TransitionPair[statecnt][];
        State[] origstates = new State[statecnt];
        for (i = 0; i < statecnt; ++i) {
            origstates[i] = cstate.states[i];
        }
        for (i = 0; i < statecnt; ++i) {
            transmatrix[i] = this.nodes[i].getTransitions((State)cstate.states[i]).transitions;
            totalcnt += transmatrix[i].length;
        }
        TransitionPair[] result = new TransitionPair[totalcnt];
        int idx = 0;
        for (int i2 = 0; i2 < statecnt; ++i2) {
            int j = 0;
            while (j < transmatrix[i2].length) {
                State[] item = new State[statecnt];
                for (int k = 0; k < statecnt; ++k) {
                    item[k] = origstates[k];
                }
                item[i2] = transmatrix[i2][j].state;
                result[idx] = new TransitionPair(transmatrix[i2][j].eventIndex, new CompositeState(item));
                ++j;
                ++idx;
            }
        }
        return new TransitionPairs(result);
    }

    public long getWeight() {
        if (this.weight != -1L) {
            return this.weight;
        }
        this.weight = 1L;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.weight *= this.nodes[i].getWeight();
        }
        return this.weight;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"AndParallel", "|"};
        return result;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        CompositeState cstate = (CompositeState)state;
        int nodecnt = this.nodes.length;
        String result = new String();
        ArrayList<Integer> indicesresult = new ArrayList<Integer>();
        result = "(";
        for (int i = 0; i < nodecnt; ++i) {
            AnotatedProtocol subresult = this.nodes[i].getAnotatedProtocol(cstate != null ? cstate.states[i] : null);
            for (int j = 0; j < subresult.indices.size(); ++j) {
                indicesresult.add(new Integer((Integer)subresult.indices.get(j) + result.length()));
            }
            result = result + subresult.protocol;
            if (i >= nodecnt - 1) continue;
            result = result + ")|(";
        }
        result = result + ")";
        return new AnotatedProtocol(result, indicesresult);
    }

    private static String getProtocol(TreeNode[] nodes) {
        String result = new String();
        result = "(" + nodes[0].protocol + ")";
        for (int i = 1; i < nodes.length; ++i) {
            result = result + " | (" + nodes[i].protocol + ")";
        }
        return result;
    }
}

