/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.DenotedState;
import org.objectweb.fractal.bpc.checker.state.SimpleState;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class AlternativeNode
extends TreeNode {
    private DenotedState initState;
    private int logchildrencnt;
    private boolean isorparallel;
    public String probLeft = null;
    public String probRight = null;

    public AlternativeNode(TreeNode[] nodes) {
        super(AlternativeNode.getProtocol(nodes));
        this.nodes = nodes;
        this.isorparallel = false;
        this.initState = null;
    }

    public State getInitial() {
        if (this.initState == null) {
            this.initState = new DenotedState(-1, new SimpleState(0), this.logchildrencnt, this);
        }
        return this.initState;
    }

    public State getAccepting() {
        return new DenotedState(-2, new SimpleState(0), this.logchildrencnt, this);
    }

    public boolean isAccepting(State state) {
        int index = ((DenotedState)state).index;
        if (index == -1) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!this.nodes[i].isAccepting(this.nodes[i].getInitial())) continue;
                return true;
            }
            return false;
        }
        return index == -2 || this.nodes[index].isAccepting(((DenotedState)state).state);
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException, CheckingException {
        DenotedState dstate = (DenotedState)state;
        int stindex = dstate.index;
        int nodecnt = this.nodes.length;
        int totallen = 0;
        if (stindex == -2) {
            return new TransitionPairs(new TransitionPair[0]);
        }
        if (stindex == -1) {
            TransitionPair[][] trans = new TransitionPair[nodecnt][];
            for (int i = 0; i < nodecnt; ++i) {
                trans[i] = this.nodes[i].getTransitions((State)this.nodes[i].getInitial()).transitions;
                totallen += trans[i].length;
            }
            TransitionPair[] result = new TransitionPair[totallen];
            int i = 0;
            for (int idx = 0; idx < nodecnt; ++idx) {
                int j = 0;
                while (j < trans[idx].length) {
                    State newstate = trans[idx][j].state;
                    result[i] = new TransitionPair(trans[idx][j].eventIndex, new DenotedState(idx, newstate, this.logchildrencnt, this));
                    ++j;
                    ++i;
                }
            }
            return new TransitionPairs(result);
        }
        TransitionPair[] nodetrans = this.nodes[stindex].getTransitions((State)dstate.state).transitions;
        TransitionPair[] trans = new TransitionPair[nodetrans.length];
        for (int i = 0; i < nodetrans.length; ++i) {
            trans[i] = new TransitionPair(nodetrans[i].eventIndex, new DenotedState(stindex, nodetrans[i].state, this.logchildrencnt, this));
        }
        return new TransitionPairs(trans);
    }

    public long getWeight() {
        if (this.weight != -1L) {
            return this.weight;
        }
        long weight = 0L;
        for (int i = 0; i < this.nodes.length; ++i) {
            weight += this.nodes[i].getWeight();
        }
        return weight;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"Alternative", "+"};
        return result;
    }

    public int getLeafCount() {
        int cnt = 0;
        for (int i = 0; i < this.nodes.length; ++i) {
            cnt += this.nodes[i].getLeafCount();
        }
        int max = 0;
        for (int i = 0; i < 32; ++i) {
            if (this.nodes.length >>> i != 0) continue;
            max = i;
            break;
        }
        this.logchildrencnt = max;
        return cnt += this.nodes.length * max;
    }

    public void setorparallel() {
        this.isorparallel = true;
    }

    public boolean getorparallel() {
        return this.isorparallel;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        DenotedState dstate = (DenotedState)state;
        int nodecnt = this.nodes.length;
        String result = new String();
        ArrayList<Integer> indicesresult = new ArrayList<Integer>();
        result = "(";
        for (int i = 0; i < nodecnt; ++i) {
            AnotatedProtocol subresult = this.nodes[i].getAnotatedProtocol(dstate != null && dstate.index == i ? dstate.state : null);
            for (int j = 0; j < subresult.indices.size(); ++j) {
                indicesresult.add(new Integer((Integer)subresult.indices.get(j) + result.length()));
            }
            result = result + subresult.protocol;
            if (i >= nodecnt - 1) continue;
            result = result + ")+(";
        }
        result = result + ")";
        if (dstate != null && dstate.index == -1) {
            indicesresult.add(new Integer(0));
        }
        return new AnotatedProtocol(result, indicesresult);
    }

    private static String getProtocol(TreeNode[] nodes) {
        String result = new String();
        result = "(" + nodes[0].protocol + ")";
        for (int i = 1; i < nodes.length; ++i) {
            result = result + " + (" + nodes[i].protocol + ")";
        }
        return result;
    }
}

