/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.CompositeState;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.state.TransitionPairs;
import org.objectweb.fractal.bpc.checker.utils.AnotatedProtocol;

public class AdjustmentNode
extends TreeNode {
    private final TreeSet events;

    public AdjustmentNode(TreeNode node1, TreeNode node2, TreeSet events) {
        super("(" + node1.protocol + ") " + "|S|" + " (" + node2.protocol + ")");
        this.events = events;
        this.nodes = new TreeNode[2];
        this.nodes[0] = node1;
        this.nodes[1] = node2;
    }

    public State getInitial() {
        State[] states = new State[]{this.nodes[0].getInitial(), this.nodes[1].getInitial()};
        return new CompositeState(states);
    }

    public boolean isAccepting(State state) {
        CompositeState cstate = (CompositeState)state;
        return this.nodes[0].isAccepting(cstate.states[0]) && this.nodes[1].isAccepting(cstate.states[1]);
    }

    public TransitionPairs getTransitions(State state) throws InvalidParameterException, CheckingException {
        State[] states;
        Integer basekey;
        Integer key;
        int i;
        CompositeState cstate = (CompositeState)state;
        TransitionPair[] trans1 = this.nodes[0].getTransitions((State)cstate.states[0]).transitions;
        TransitionPair[] trans2 = this.nodes[1].getTransitions((State)cstate.states[1]).transitions;
        ArrayList<TransitionPair> result = new ArrayList<TransitionPair>();
        TreeMap sync = new TreeMap();
        for (i = 0; i < trans1.length; ++i) {
            key = new Integer(trans1[i].eventIndex);
            basekey = new Integer(ActionRepository.getPure(key));
            if (this.events.contains(basekey)) {
                if (sync.containsKey(key)) {
                    ((ArrayList)sync.get(key)).add(trans1[i]);
                    continue;
                }
                ArrayList<TransitionPair> value = new ArrayList<TransitionPair>();
                value.add(trans1[i]);
                sync.put(new Integer(trans1[i].eventIndex), value);
                continue;
            }
            states = new State[]{trans1[i].state, cstate.states[1]};
            result.add(new TransitionPair(trans1[i].eventIndex, new CompositeState(states)));
        }
        for (i = 0; i < trans2.length; ++i) {
            key = new Integer(trans2[i].eventIndex);
            basekey = new Integer(ActionRepository.getPure(key));
            if (this.events.contains(basekey)) {
                if (!sync.containsKey(key)) continue;
                Iterator it = ((ArrayList)sync.get(key)).iterator();
                while (it.hasNext()) {
                    State[] states2 = new State[]{((TransitionPair)it.next()).state, trans2[i].state};
                    result.add(new TransitionPair(trans2[i].eventIndex, new CompositeState(states2)));
                }
                continue;
            }
            states = new State[]{cstate.states[0], trans2[i].state};
            result.add(new TransitionPair(trans2[i].eventIndex, new CompositeState(states)));
        }
        TransitionPair[] result1 = new TransitionPair[result.size()];
        Iterator it = result.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            result1[i2++] = (TransitionPair)it.next();
        }
        return new TransitionPairs(result1);
    }

    public long getWeight() {
        if (this.weight != -1L) {
            return this.weight;
        }
        this.weight = this.nodes[0].getWeight() * this.nodes[1].getWeight();
        return this.weight;
    }

    public TreeNode forwardCut(TreeSet livingevents) {
        TreeSet exlivev = new TreeSet(livingevents);
        exlivev.addAll(this.events);
        TreeSet exlivev2 = new TreeSet(exlivev);
        this.nodes[0] = this.nodes[0].forwardCut(exlivev);
        this.nodes[1] = this.nodes[1].forwardCut(exlivev2);
        if (this.nodes[0] == null || this.nodes[1] == null) {
            return null;
        }
        return this;
    }

    public String[] getTypeName() {
        String[] result = new String[]{"Adjustment", "/"};
        return result;
    }

    public AnotatedProtocol getAnotatedProtocol(State state) {
        throw new RuntimeException(this.getClass().getName() + ".getAnotatedProtocol is not implemented");
    }
}

