/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.node;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.node.AtomicAction;
import org.objectweb.fractal.bpc.checker.parser.Debug;
import org.objectweb.fractal.bpc.checker.parser.SyntaxErrorException;

public class ActionRepository {
    private TreeMap repository = new TreeMap();
    private TreeMap inverseRepository = new TreeMap();
    private TreeMap atomicRepository = new TreeMap();
    private TreeMap atomicInverseRepository = new TreeMap();
    static final int VARIANTCNT = 10;
    private TreeSet usedItems = new TreeSet();

    public int addItem(String item) throws SyntaxErrorException {
        int index;
        Integer i;
        Debug.println(3, "Adding item to repository: " + item);
        try {
            i = (Integer)this.inverseRepository.get(item);
        }
        catch (ClassCastException e) {
            i = null;
        }
        catch (NullPointerException e) {
            i = null;
        }
        if (i != null) {
            this.touchItem(i);
            return i;
        }
        try {
            index = (Integer)this.repository.lastKey() + 1;
        }
        catch (NoSuchElementException e) {
            index = 0;
        }
        String purename = ActionRepository.getPureName(item);
        this.repository.put(new Integer(index), purename);
        this.inverseRepository.put(purename, new Integer(index));
        String next = "!" + purename;
        this.repository.put(new Integer(++index), next);
        this.inverseRepository.put(next, new Integer(index));
        next = "?" + purename;
        this.repository.put(new Integer(++index), next);
        this.inverseRepository.put(next, new Integer(index));
        next = "!" + purename + "^";
        this.repository.put(new Integer(++index), next);
        this.inverseRepository.put(next, new Integer(index));
        next = "?" + purename + "^";
        this.repository.put(new Integer(++index), next);
        this.inverseRepository.put(next, new Integer(index));
        next = "!" + purename + "$";
        this.repository.put(new Integer(++index), next);
        this.inverseRepository.put(next, new Integer(index));
        next = "?" + purename + "$";
        this.repository.put(new Integer(++index), next);
        this.inverseRepository.put(next, new Integer(index));
        next = "#" + purename;
        this.repository.put(new Integer(++index), next);
        this.inverseRepository.put(next, new Integer(index));
        next = "#" + purename + "^";
        this.repository.put(new Integer(++index), next);
        this.inverseRepository.put(next, new Integer(index));
        next = "#" + purename + "$";
        this.repository.put(new Integer(++index), next);
        this.inverseRepository.put(next, new Integer(index));
        Debug.println(3, "Action added");
        Integer returnindex = (Integer)this.inverseRepository.get(item);
        if (returnindex == null) {
            throw new SyntaxErrorException("This is not an event: " + item);
        }
        this.touchItem(returnindex);
        return returnindex;
    }

    public int addAtomicItem(TreeSet events) {
        Integer i;
        try {
            i = (Integer)this.atomicInverseRepository.get(events);
        }
        catch (ClassCastException e) {
            i = null;
        }
        catch (NullPointerException e) {
            i = null;
        }
        if (i != null) {
            this.touchItem(i);
            return i;
        }
        LinkedList copy = new LinkedList();
        copy.addAll(events);
        LinkedList variants = this.createAtomicVariants(copy);
        Iterator it = variants.iterator();
        while (it.hasNext()) {
            Integer index = new Integer(-1 - this.atomicRepository.size());
            AtomicAction item = new AtomicAction((Collection)((LinkedList)it.next()));
            this.atomicRepository.put(index, item);
            this.atomicInverseRepository.put(item, index);
            AtomicAction inverseaction = new AtomicAction();
            Iterator it2 = item.iterator();
            while (it2.hasNext()) {
                inverseaction.add(new Integer(this.getInverseAction((Integer)it2.next())));
            }
            index = new Integer(-1 - this.atomicRepository.size());
            this.atomicRepository.put(index, inverseaction);
            this.atomicInverseRepository.put(inverseaction, index);
        }
        return (Integer)this.atomicInverseRepository.get(new AtomicAction((Collection)events));
    }

    public TreeSet getAllUsedEventIndices() {
        return new TreeSet(this.usedItems);
    }

    public boolean getItemPresence(int index) {
        return this.repository.containsKey(new Integer(index));
    }

    public String getItemString(int index) {
        try {
            if (index >= 0) {
                return (String)this.repository.get(new Integer(index));
            }
            String result = new String("[");
            TreeSet actions = (TreeSet)this.atomicRepository.get(new Integer(index));
            Iterator it = actions.iterator();
            while (it.hasNext()) {
                result = result + this.getItemString((Integer)it.next());
                if (!it.hasNext()) continue;
                result = result + ", ";
            }
            result = result + "]";
            return result;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public int getItemIndex(String item) {
        try {
            Integer result = (Integer)this.inverseRepository.get(item);
            this.touchItem(result);
            return result;
        }
        catch (NullPointerException e) {
            if (!item.equals("")) {
                Debug.println(1, "Action repository: try to access action '" + item + "' - not present in repository.\n");
            }
            throw e;
        }
    }

    public int getItemIndex(AtomicAction action) {
        try {
            Integer result = (Integer)this.atomicInverseRepository.get(action);
            return result;
        }
        catch (NullPointerException e) {
            if (!action.equals(null)) {
                Debug.println(1, "Action repository: try to access atomic action '" + action + "'  - not present in repository.\n");
            }
            throw e;
        }
    }

    public static int getPure(int event) {
        return event / 10 * 10;
    }

    public int getInverseAction(int event) {
        if (event < 0) {
            return this.invertAtomic(event);
        }
        if (event % 10 < 7 && event % 10 > 0) {
            if (event % 2 == 1) {
                this.touchItem(event + 1);
                return event + 1;
            }
            this.touchItem(event - 1);
            return event - 1;
        }
        return event;
    }

    public int invertAtomic(int eventindex) {
        AtomicAction aa = new AtomicAction();
        Iterator it = this.getAtomicEvents(eventindex).iterator();
        while (it.hasNext()) {
            aa.add(new Integer(this.getInverseAction((Integer)it.next())));
        }
        return this.getItemIndex(aa);
    }

    public int getTauAction(int event) {
        int root = event / 10 * 10;
        int index = event % 10;
        if (index == 3 || index == 4) {
            this.touchItem(root + 8);
            return root + 8;
        }
        if (index == 5 || index == 6) {
            this.touchItem(root + 9);
            return root + 9;
        }
        this.touchItem(root + 7);
        return root + 7;
    }

    public boolean isResponse(int event) {
        int subtype = event % 10;
        return subtype == 2 || subtype == 4 || subtype == 6;
    }

    public boolean isTau(int event) {
        int subtype = event % 10;
        return subtype >= 7;
    }

    public int getEventAction(int event) {
        if (event % 10 == 3 || event % 10 == 5) {
            return event / 10 * 10 + 1;
        }
        if (event % 10 == 4 || event % 10 == 6) {
            return event / 10 * 10 + 2;
        }
        if (event % 10 == 8 || event % 10 == 9) {
            return event / 10 * 10 + 7;
        }
        return event;
    }

    private static String getPureName(String action) {
        String result = new String(action);
        char first = action.charAt(0);
        char last = action.charAt(action.length() - 1);
        if (first == '?' || first == '!' || first == '#') {
            result = result.substring(1);
        }
        if (last == '^' || last == '$') {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void touchItem(int index) {
        if (index % 10 != 0 && index % 10 != 1 && index % 10 != 2 && index % 10 != 7) {
            this.usedItems.add(new Integer(index));
        }
    }

    public AtomicAction getAtomicEvents(int atomicactionindex) {
        return (AtomicAction)this.atomicRepository.get(new Integer(atomicactionindex));
    }

    private LinkedList createAtomicVariants(LinkedList events) {
        LinkedList<LinkedList> result = new LinkedList<LinkedList>();
        LinkedList<Integer> subresult2 = new LinkedList<Integer>();
        if (events.size() == 0) {
            return result;
        }
        if (events.size() == 1) {
            subresult2.add((Integer)events.getFirst());
            result.add(subresult2);
            subresult2 = new LinkedList<Integer>();
            subresult2.add(new Integer(this.getTauAction((Integer)events.getFirst())));
            result.add(subresult2);
            return result;
        }
        Integer first = (Integer)events.removeFirst();
        LinkedList subresult1 = this.createAtomicVariants(events);
        subresult2 = this.duplicateList(subresult1);
        Iterator it = subresult1.iterator();
        while (it.hasNext()) {
            LinkedList item = (LinkedList)it.next();
            item.add(first);
            result.add(item);
        }
        Integer tau = new Integer(this.getTauAction(first));
        it = subresult2.iterator();
        while (it.hasNext()) {
            LinkedList item = (LinkedList)it.next();
            item.add(tau);
            result.add(item);
        }
        return result;
    }

    private LinkedList duplicateList(LinkedList source) {
        LinkedList newlist = new LinkedList();
        Iterator it = source.iterator();
        while (it.hasNext()) {
            LinkedList item = (LinkedList)it.next();
            LinkedList<Integer> newitem = new LinkedList<Integer>();
            Iterator internal = item.iterator();
            while (internal.hasNext()) {
                newitem.add(new Integer((Integer)internal.next()));
            }
            newlist.add(newitem);
        }
        return newlist;
    }

    public void flushCache() {
        Iterator it = this.repository.keySet().iterator();
        while (it.hasNext()) {
            System.out.println(this.repository.get((Integer)it.next()));
        }
    }
}

