/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.backend;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.CheckingResult;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.DFSR.DFSRDotVis;
import org.objectweb.fractal.bpc.checker.DFSR.DFSRTraverser;
import org.objectweb.fractal.bpc.checker.DFSR.ItemAlreadyPresentException;
import org.objectweb.fractal.bpc.checker.DFSR.ItemNotPresentException;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.backend.ConsentBackend;
import org.objectweb.fractal.bpc.checker.backend.IBackend;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.ConsentNode;
import org.objectweb.fractal.bpc.checker.node.DeterministicNode;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.optimizer.OptExplicit;
import org.objectweb.fractal.bpc.checker.parser.Debug;
import org.objectweb.fractal.bpc.checker.state.Signature;
import org.objectweb.fractal.bpc.checker.visualization.DotVisualizer;

public class DotVisBackend
implements IBackend {
    private ActionRepository repository;

    public DotVisBackend(ActionRepository repository) {
        this.repository = repository;
    }

    public CheckingResult perform(TreeNode[] nodes, String[] synchroops, String[] unboundops) {
        if (nodes.length < 2) {
            return new CheckingResult(5, "Visualization backend: wrong number of items within the first array parameter (at least two required.\n");
        }
        if (synchroops.length != nodes.length - 1) {
            return new CheckingResult(5, "Visualization backend: wrong number of items within the second array parameter (1 lower than the number of components required).\n");
        }
        DotVisualizer dotviz = new DotVisualizer(this.repository);
        for (int i = 0; i < nodes.length; ++i) {
            dotviz.visualize(nodes[i], "pt_" + i + ".dt");
        }
        nodes[0] = ConsentBackend.invertProtocol(nodes[0], this.repository);
        TreeNode result = new DeterministicNode(nodes[nodes.length - 1]);
        TreeSet<Integer> unbound = new TreeSet<Integer>();
        for (int y = 0; y < unboundops.length; ++y) {
            unbound.add(new Integer(this.repository.getItemIndex(unboundops[y])));
        }
        for (int j = nodes.length - 2; j > 0; --j) {
            TreeSet<Integer> prov = new TreeSet<Integer>();
            String[] sprov = synchroops[j].equals("") ? new String[]{} : synchroops[j].split(",");
            for (int i = 0; i < sprov.length; ++i) {
                int index;
                try {
                    index = this.repository.getItemIndex(sprov[i]);
                }
                catch (NullPointerException e) {
                    continue;
                }
                prov.add(new Integer(index));
            }
            result = new ConsentNode(new DeterministicNode(nodes[j]), result, prov, unbound, this.repository, false);
        }
        TreeSet<Integer> prov = new TreeSet<Integer>();
        String[] sprov = synchroops[0].equals("") ? new String[]{} : synchroops[0].split(",");
        for (int i = 0; i < sprov.length; ++i) {
            int index;
            try {
                index = this.repository.getItemIndex(sprov[i]);
            }
            catch (NullPointerException e) {
                continue;
            }
            prov.add(new Integer(index));
        }
        ConsentNode top = new ConsentNode(new DeterministicNode(nodes[0]), result, prov, unbound, this.repository, false);
        Debug.println("State space estimate: " + top.getWeight());
        Debug.print("Optimizing the parse tree for the composition test......");
        try {
            if (Options.forwardcutting) {
                top = (ConsentNode)top.forwardCut(this.repository.getAllUsedEventIndices());
            }
            if (top != null) {
                Signature.setSize(top.getLeafCount());
            }
            if (Options.explicit && top != null) {
                top = (ConsentNode)new OptExplicit(top, Options.explicitsize).perform();
            }
        }
        catch (InvalidParameterException e) {
            return new CheckingResult(5, "Error while performing optimization. Bailing out....");
        }
        Debug.println("done.");
        if (top != null) {
            DFSRTraverser dfsr1 = new DFSRTraverser(top, this.repository);
            try {
                FileOutputStream outputfile = new FileOutputStream("a_main.dt");
                outputfile.write("digraph G {\n  size = \"7,11\";\n".getBytes());
                dfsr1.run(new DFSRDotVis(outputfile, top, this.repository));
                outputfile.write("\n}".getBytes());
                outputfile.close();
            }
            catch (CheckingException e) {
                return new CheckingResult(5, "End of checking while vizualizating, need a fix! - " + e.getMessage());
            }
            catch (InvalidParameterException e) {
                return new CheckingResult(5, "Error while checking (Invalid parameter exception): " + e.getMessage());
            }
            catch (ItemAlreadyPresentException e) {
                return new CheckingResult(5, "Error while checking (ItemAlreadyPresentException): " + e.getMessage());
            }
            catch (ItemNotPresentException e) {
                return new CheckingResult(5, "Error while checking (ItemNotPresentException): " + e.getMessage());
            }
            catch (FileNotFoundException e) {
                return new CheckingResult(5, "Couldn't open file automaton1.dt");
            }
            catch (IOException e) {
                return new CheckingResult(5, "IOException while writing to the file a_main.dt");
            }
        }
        return null;
    }
}

