/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.backend;

import java.util.TreeSet;
import org.objectweb.fractal.bpc.checker.CheckingResult;
import org.objectweb.fractal.bpc.checker.DFSR.AcceptingStateException;
import org.objectweb.fractal.bpc.checker.DFSR.BadActivityException;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.DFSR.DFSRConsent;
import org.objectweb.fractal.bpc.checker.DFSR.DFSRTraverser;
import org.objectweb.fractal.bpc.checker.DFSR.InfiniteActivityException;
import org.objectweb.fractal.bpc.checker.DFSR.ItemAlreadyPresentException;
import org.objectweb.fractal.bpc.checker.DFSR.ItemNotPresentException;
import org.objectweb.fractal.bpc.checker.DFSR.NoActivityException;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.backend.IBackend;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.AlternativeNode;
import org.objectweb.fractal.bpc.checker.node.AtomicNode;
import org.objectweb.fractal.bpc.checker.node.ConsentNode;
import org.objectweb.fractal.bpc.checker.node.DeterministicNode;
import org.objectweb.fractal.bpc.checker.node.EventNode;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.optimizer.OptExplicit;
import org.objectweb.fractal.bpc.checker.parser.Debug;
import org.objectweb.fractal.bpc.checker.state.Signature;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;

public class ConsentBackend
implements IBackend {
    private ActionRepository repository;

    public ConsentBackend(ActionRepository repository) {
        this.repository = repository;
    }

    public CheckingResult perform(TreeNode[] nodes, String[] synchroops, String[] unboundops) {
        if (nodes.length < 2) {
            return new CheckingResult(5, "Consent backend: wrong number of items within the first array parameter (at least two required).\n");
        }
        if (synchroops.length != nodes.length - 1) {
            return new CheckingResult(5, "Consent backend: wrong number of items within the second array parameter (1 lower than the number of components required).\n");
        }
        if (Options.action == 1) {
            nodes[0] = ConsentBackend.invertProtocol(nodes[0], this.repository);
        }
        TreeNode result = new DeterministicNode(nodes[nodes.length - 1]);
        TreeSet<Integer> unbound = new TreeSet<Integer>();
        for (int y = 0; y < unboundops.length; ++y) {
            try {
                unbound.add(new Integer(this.repository.getItemIndex(unboundops[y])));
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        for (int j = nodes.length - 2; j > 0; --j) {
            TreeSet<Integer> prov = new TreeSet<Integer>();
            String[] sprov = synchroops[j].equals("") ? new String[]{} : synchroops[j].split(",");
            for (int i = 0; i < sprov.length; ++i) {
                int index;
                try {
                    index = this.repository.getItemIndex(sprov[i]);
                }
                catch (NullPointerException e) {
                    continue;
                }
                prov.add(new Integer(index));
            }
            result = new ConsentNode(new DeterministicNode(nodes[j]), result, prov, new TreeSet(), this.repository, true);
        }
        TreeSet<Integer> prov = new TreeSet<Integer>();
        String[] sprov = synchroops[0].equals("") ? new String[]{} : synchroops[0].split(",");
        for (int i = 0; i < sprov.length; ++i) {
            int index;
            try {
                index = this.repository.getItemIndex(sprov[i]);
            }
            catch (NullPointerException e) {
                continue;
            }
            prov.add(new Integer(index));
        }
        ConsentNode top = new ConsentNode(new DeterministicNode(nodes[0]), result, prov, unbound, this.repository, true);
        Debug.println("State space estimate: " + top.getWeight());
        Debug.print("Optimizing the parse tree for the composition test......");
        try {
            if (Options.forwardcutting) {
                top = (ConsentNode)top.forwardCut(this.repository.getAllUsedEventIndices());
            }
            if (top != null) {
                Signature.setSize(top.getLeafCount());
            }
            if (Options.explicit && top != null) {
                top = (ConsentNode)new OptExplicit(top, Options.explicitsize).perform();
            }
        }
        catch (InvalidParameterException e) {
            return new CheckingResult(5, "Error while performing optimization. Bailing out....");
        }
        Debug.println("done.");
        if (top != null) {
            TransitionPair.repository = this.repository;
            DFSRTraverser dfsr1 = new DFSRTraverser(top, this.repository);
            try {
                dfsr1.run(new DFSRConsent(top));
            }
            catch (AcceptingStateException e) {
                return new CheckingResult(5, "Internal Checker error " + e.getMessage());
            }
            catch (BadActivityException e) {
                return new CheckingResult(1, "Composition error detected - " + e.getMessage());
            }
            catch (NoActivityException e) {
                return new CheckingResult(2, "Composition error detected - " + e.getMessage());
            }
            catch (InfiniteActivityException e) {
                return new CheckingResult(3, "Composition error detected - " + e.getMessage());
            }
            catch (CheckingException e) {
                return new CheckingResult(5, "Unknown error while checking - " + e.getMessage());
            }
            catch (InvalidParameterException e) {
                return new CheckingResult(5, "Error while checking (Invalid parameter exception): " + e.getMessage());
            }
            catch (ItemAlreadyPresentException e) {
                return new CheckingResult(5, "Error while checking (ItemAlreadyPresentException): " + e.getMessage());
            }
            catch (ItemNotPresentException e) {
                return new CheckingResult(5, "Error while checking (ItemNotPresentException): " + e.getMessage());
            }
        } else {
            Debug.println("Warning: Automaton for consent is empty!");
        }
        Debug.println("Protocols are composition error free.");
        return new CheckingResult(0, "OK");
    }

    public static TreeNode invertProtocol(TreeNode protocol, ActionRepository repository) {
        if (protocol instanceof EventNode) {
            return new EventNode(repository.getInverseAction(((EventNode)protocol).getEventIndex()), repository);
        }
        if (protocol instanceof AtomicNode) {
            return new AtomicNode(repository.getInverseAction(((AtomicNode)protocol).getEventIndex()), repository);
        }
        if (protocol instanceof AlternativeNode && ((AlternativeNode)protocol).getorparallel()) {
            protocol.changeChild(2, ConsentBackend.invertProtocol(protocol.getChildren()[2], repository));
            if (protocol.getChildren()[0] instanceof EventNode) {
                protocol.changeChild(0, ConsentBackend.invertProtocol(protocol.getChildren()[0], repository));
            }
            if (protocol.getChildren()[1] instanceof EventNode) {
                protocol.changeChild(1, ConsentBackend.invertProtocol(protocol.getChildren()[1], repository));
            }
            return protocol;
        }
        TreeNode[] children = protocol.getChildren();
        for (int i = 0; i < children.length; ++i) {
            protocol.changeChild(i, ConsentBackend.invertProtocol(children[i], repository));
        }
        return protocol;
    }
}

