/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.objectweb.fractal.bpc.checker.CheckingResult;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.backend.ConsentBackend;
import org.objectweb.fractal.bpc.checker.backend.DotVisBackend;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.parser.Builder;
import org.objectweb.fractal.bpc.checker.parser.Debug;
import org.objectweb.fractal.bpc.checker.parser.FileTokenizer;
import org.objectweb.fractal.bpc.checker.parser.ProtocolReader;
import org.objectweb.fractal.bpc.checker.parser.StringTokenizer;
import org.objectweb.fractal.bpc.checker.parser.SyntaxErrorException;

public class StandaloneMain {
    public static void main(String[] args) {
        String[] cldata = Options.parseCommandLine(args);
        if ((cldata == null || cldata.length < 4) && Options.inputfile.equals("")) {
            StandaloneMain.printUsageAndExit();
        }
        try {
            if (Options.action == 1 || Options.action == 2) {
                String unbound;
                String[] provs;
                long ms = System.currentTimeMillis();
                ActionRepository repository = new ActionRepository();
                Object[] parsed = StandaloneMain.buildTrees(cldata, repository);
                TreeNode[] nodes = (TreeNode[])parsed[0];
                String result = new ConsentBackend(repository).perform(nodes, provs = (String[])parsed[1], (unbound = (String)parsed[2]).equals("") ? new String[]{} : unbound.split(",")).toString();
                if (result != null) {
                    System.out.println(result);
                } else {
                    System.out.println("OK");
                }
                Debug.println("Taken " + (System.currentTimeMillis() - ms) / 1000L + " seconds.");
            } else {
                String result;
                ActionRepository repository = new ActionRepository();
                Object[] parsed = StandaloneMain.buildTrees(cldata, repository);
                TreeNode[] nodes = (TreeNode[])parsed[0];
                String[] provs = (String[])parsed[1];
                String unbound = (String)parsed[2];
                DotVisBackend visb = new DotVisBackend(repository);
                CheckingResult cr = visb.perform(nodes, provs, unbound.equals("") ? new String[]{} : unbound.split(","));
                String string = result = cr == null ? null : cr.toString();
                if (result != null) {
                    System.out.println(result);
                }
                System.out.println("Visualization completed!");
            }
        }
        catch (SyntaxErrorException e) {
            System.out.println("Syntax error exception: " + e.getMessage());
        }
    }

    private static void printUsageAndExit() {
        System.out.println("Syntax:\njava -jar checker.jar --action=<test|testconsent|visualizedot> [--verbose|-v=<0|1|2>] [--nomultinodes|-m] [--noexplicit|-e] [--noforwardcut|-f] [--nobadactivity|-b] [--nonpactivity|-n] [--infiniteactivity|-i=<yes|no|notrace>] [(--totalmem|-t)=<size>] [(--cachesize|-s)=<size>] <((--file|-f)=<inputfile>) | (<protocol1> <provisions_1_2> <protocol2> [<provisions_2_3> <protocol3>, ...] <unbound_operations)>");
        System.exit(1);
    }

    private static String removeSpaces(String src) {
        StringBuffer buffer = new StringBuffer(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (Builder.isWhiteSpace(c)) continue;
            buffer.append(c);
        }
        return new String(buffer);
    }

    static Object[] buildTrees(String[] inputdata, ActionRepository repository) throws SyntaxErrorException {
        int i;
        FileTokenizer reader;
        ArrayList<TreeNode> prots = new ArrayList<TreeNode>();
        ArrayList<String> provs = new ArrayList<String>();
        Builder parser = new Builder(repository);
        if (Options.inputfile.equals("")) {
            TreeNode[] nodes = new TreeNode[inputdata.length / 2];
            String[] provisions = new String[inputdata.length / 2 - 1];
            int j = 0;
            for (int i2 = 0; i2 < inputdata.length / 2 - 1; ++i2) {
                nodes[i2] = parser.build(new StringTokenizer(inputdata[j++]), false);
                provisions[i2] = StandaloneMain.removeSpaces(inputdata[j++]);
            }
            nodes[i2] = parser.build(new StringTokenizer(inputdata[j++]), false);
            String unbound = StandaloneMain.removeSpaces(inputdata[j++]);
            Object[] result = new Object[]{nodes, provisions, unbound};
            return result;
        }
        try {
            reader = new FileTokenizer(Options.inputfile);
        }
        catch (IOException e) {
            throw new SyntaxErrorException("Cannot read the source file");
        }
        while (true) {
            ((ProtocolReader)reader).resetIndex();
            TreeNode node = parser.build(reader, false);
            if (node == null) break;
            prots.add(node);
            provs.add(StandaloneMain.parseSynchro(reader));
        }
        try {
            ((Reader)reader).close();
        }
        catch (IOException e) {
            Debug.println("Warning: unable to close input file");
        }
        TreeNode[] nodes = new TreeNode[prots.size()];
        String[] provisions = new String[provs.size() - 1];
        String unbound = StandaloneMain.removeSpaces((String)provs.get(provs.size() - 1));
        for (i = 0; i < prots.size(); ++i) {
            nodes[i] = (TreeNode)prots.get(i);
        }
        for (i = 0; i < provs.size() - 1; ++i) {
            provisions[i] = (String)provs.get(i);
        }
        Object[] result = new Object[]{nodes, provisions, unbound};
        return result;
    }

    private static String parseSynchro(ProtocolReader reader) throws SyntaxErrorException {
        String result = new String();
        try {
            char c;
            while ((c = (char)reader.read()) != '\uffff') {
                result = result + c;
            }
            Debug.println("Synchroops: " + result);
            return result;
        }
        catch (IOException e) {
            throw new SyntaxErrorException("Error while reading the input file");
        }
    }
}

