/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.fractal.bpc.checker.DFSR.JPFCooperatingTraverser;
import org.objectweb.fractal.bpc.checker.DFSR.JPFTraverser;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.DeterministicNode;
import org.objectweb.fractal.bpc.checker.node.EventNode;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.parser.Builder;
import org.objectweb.fractal.bpc.checker.parser.StringTokenizer;
import org.objectweb.fractal.bpc.checker.parser.SyntaxErrorException;
import org.objectweb.fractal.bpc.checker.state.Signature;

public class JPFStaticChecker {
    private JPFTraverser notifee;
    private TreeNode rootNode;

    public JPFStaticChecker(String protocol, boolean cooperating, PrintStream output) throws SyntaxErrorException {
        ActionRepository repository = new ActionRepository();
        this.rootNode = new DeterministicNode(new Builder(repository).build(new StringTokenizer(protocol), true));
        if (this.rootNode != null) {
            Signature.setSize(this.rootNode.getLeafCount());
        }
        this.notifee = cooperating ? new JPFCooperatingTraverser(this.rootNode, repository, output) : new JPFTraverser(this.rootNode, repository, output);
    }

    public JPFTraverser getNotifee() {
        return this.notifee;
    }

    public static String[] getEvents(String protoStr) throws Exception {
        StringTokenizer st = new StringTokenizer(protoStr);
        ActionRepository ar = new ActionRepository();
        Builder b = new Builder(ar);
        TreeNode protoNode = b.build(st, false);
        HashSet eventNames = new HashSet();
        JPFStaticChecker.extractEventNames(protoNode, eventNames);
        return eventNames.toArray(new String[eventNames.size()]);
    }

    public boolean wantsBacktrack() {
        return this.notifee.wantsBacktrack();
    }

    private static void extractEventNames(TreeNode tn, Set eventNames) {
        if (tn instanceof EventNode) {
            eventNames.add(tn.protocol.substring(1, tn.protocol.length() - 1));
            return;
        }
        TreeNode[] children = tn.getChildren();
        for (int i = 0; i < children.length; ++i) {
            JPFStaticChecker.extractEventNames(children[i], eventNames);
        }
    }

    public void writeUsageFile(OutputStream out) throws IOException {
        this.notifee.writeUsageFile(out);
    }
}

