/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.DFSR;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.objectweb.fractal.bpc.checker.DFSR.ItemAlreadyPresentException;
import org.objectweb.fractal.bpc.checker.DFSR.ItemNotPresentException;
import org.objectweb.fractal.bpc.checker.parser.Debug;
import org.objectweb.fractal.bpc.checker.state.Signature;

public class StateCache {
    private HashMap cache;
    private final float load = 0.75f;
    private final int maximalCapacity;
    private final int cachePurgeRatio = 8;
    private int currentPurgeIndex = 0;

    public StateCache(int maximalcapacity) {
        int initialcapacity = 1000;
        this.cache = new HashMap(initialcapacity, 0.75f);
        this.maximalCapacity = maximalcapacity != 0 ? maximalcapacity : Integer.MAX_VALUE;
        Debug.println(2, "Cache created with capacity of " + this.maximalCapacity + " items.");
    }

    public void insert(Signature item) throws ItemAlreadyPresentException {
        if (this.cache.size() >= this.maximalCapacity) {
            Iterator it = this.cache.keySet().iterator();
            int size = this.cache.size() / 8;
            Debug.print(2, "Purging the cache.....");
            ArrayList keys = new ArrayList();
            try {
                for (int i = 0; i < size; ++i) {
                    int j;
                    for (j = 0; j < this.currentPurgeIndex; ++j) {
                        it.next();
                    }
                    keys.add(it.next());
                    for (j = 0; j < 8 - this.currentPurgeIndex - 1; ++j) {
                        it.next();
                    }
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            Iterator it2 = keys.iterator();
            size = keys.size();
            for (int i = 0; i < size; ++i) {
                this.cache.remove(it2.next());
            }
            this.currentPurgeIndex = (this.currentPurgeIndex + 1) % 8;
            Debug.println(size + " keys purged.");
        }
        if (this.cache.put(item, item) != null) {
            throw new ItemAlreadyPresentException();
        }
    }

    public boolean isPresent(Signature item) {
        return this.cache.containsKey(item);
    }

    public void remove(Signature item) throws ItemNotPresentException {
        if (this.cache.remove(item) == null) {
            throw new ItemNotPresentException();
        }
    }

    public boolean acceptingReach(Signature signature) {
        try {
            return ((Signature)this.cache.get((Object)signature)).acceptingCycleId >>> 63 != 0L;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public void setAcceptingReach(Signature signature) {
        try {
            this.remove(signature);
        }
        catch (ItemNotPresentException e) {
            return;
        }
        signature.setAcceptingReachable(true);
        if (this.cache.put(signature, signature) != null) {
            throw new RuntimeException("Inconsistent state cache");
        }
    }

    public long getCycleId(Signature signature) {
        Signature sig = (Signature)this.cache.get(signature);
        return sig.acceptingCycleId & Long.MAX_VALUE;
    }

    public void setCycleId(Signature signature, long id) {
        Signature sig = (Signature)this.cache.get(signature);
        sig.acceptingCycleId = (sig.acceptingCycleId >> 63 & 1L) != 0L ? id | Long.MIN_VALUE : id & Long.MAX_VALUE;
    }

    public void updateItem(Signature signature) {
        try {
            this.remove(signature);
        }
        catch (ItemNotPresentException e) {
            return;
        }
        if (this.cache.put(signature, signature) != null) {
            throw new RuntimeException("Inconsistent state cache");
        }
    }

    public void clear() {
        this.cache.clear();
    }
}

