/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.DFSR;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Stack;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.utils.ProtocolUsageMonitor;

public class JPFTraverser {
    protected TreeNode node;
    protected ActionRepository repository;
    protected Stack eventStack;
    protected Stack stateStack;
    protected State current;
    protected boolean wasOutput = false;
    protected PrintStream output;

    public JPFTraverser(TreeNode node, ActionRepository repository, PrintStream output) {
        this.node = node;
        this.eventStack = new Stack();
        this.stateStack = new Stack();
        this.repository = repository;
        this.output = output;
        this.current = node.getInitial();
    }

    public boolean notifyForwardInvoke(int thread, boolean isClientItf, String event) {
        String token = (isClientItf ? "!" : "?") + event + "^";
        return this.makeStep(token);
    }

    public boolean notifyForwardReturn(int thread, boolean isClientItf, String event) {
        String token = (isClientItf ? "?" : "!") + event + "$";
        return this.makeStep(token);
    }

    public boolean notifyBackwardInvoke(int thread, boolean isClientItf, String event) {
        String token = (isClientItf ? "!" : "?") + event + "^";
        return this.undoStep(token);
    }

    public boolean notifyBackwardReturn(int thread, boolean isClientItf, String event) {
        String token = (isClientItf ? "?" : "!") + event + "$";
        return this.undoStep(token);
    }

    public boolean notifyEnd() {
        if (this.node.isAccepting(this.current)) {
            return true;
        }
        this.printStack("");
        return false;
    }

    public boolean wantsBacktrack() {
        throw new UnsupportedOperationException();
    }

    public void writeUsageFile(OutputStream out) throws IOException {
        ProtocolUsageMonitor.printUsage(out, this.node);
    }

    protected boolean makeStep(String event) {
        int action;
        boolean found = false;
        try {
            action = this.repository.getItemIndex(event);
        }
        catch (NullPointerException e) {
            this.printStack(event);
            return false;
        }
        TransitionPair[] transitions = null;
        try {
            transitions = this.node.getTransitions((State)this.current).transitions;
        }
        catch (InvalidParameterException e) {
            this.output.println("Internal Checker Error - InvalidParameterException");
            e.printStackTrace();
            return false;
        }
        catch (CheckingException e) {
            this.output.println("Internal Checker Error - CheckingException");
            e.printStackTrace();
            return false;
        }
        for (int i = 0; i < transitions.length; ++i) {
            if (transitions[i].eventIndex != action) continue;
            this.eventStack.push(event);
            this.stateStack.push(this.current);
            this.current = transitions[i].state;
            found = true;
            if (!Options.monitorusage) break;
            ProtocolUsageMonitor.eventExecuted(transitions[i].eventIndex);
            break;
        }
        if (!found) {
            this.printStack(event);
            return false;
        }
        return true;
    }

    protected boolean undoStep(String event) {
        if (this.eventStack.peek().equals(event)) {
            this.eventStack.pop();
            this.current = (State)this.stateStack.peek();
            this.stateStack.pop();
            return true;
        }
        this.printStack(event);
        return false;
    }

    protected void printStack(String badEvent) {
        if (!this.wasOutput) {
            this.wasOutput = true;
            this.output.println("Protocol error trace start");
            for (int i = 0; i < this.eventStack.size(); ++i) {
                this.output.println((String)this.eventStack.get(i));
            }
            this.output.println(badEvent);
            this.output.println("Protocol error trace end");
        }
    }
}

