/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.DFSR;

import java.io.PrintStream;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.DFSR.ItemAlreadyPresentException;
import org.objectweb.fractal.bpc.checker.DFSR.JPFTraverser;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.DFSR.StateCache;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;
import org.objectweb.fractal.bpc.checker.utils.ProtocolUsageMonitor;

public class JPFCooperatingTraverser
extends JPFTraverser {
    private StateCache globalCache = new StateCache(0);
    private boolean visitedState = false;

    public JPFCooperatingTraverser(TreeNode node, ActionRepository repository, PrintStream output) {
        super(node, repository, output);
    }

    public boolean wantsBacktrack() {
        if (this.eventStack.empty()) {
            return true;
        }
        return this.visitedState || this.node.isAccepting(this.current);
    }

    protected boolean makeStep(String event) {
        int action;
        boolean found = false;
        try {
            action = this.repository.getItemIndex(event);
        }
        catch (NullPointerException e) {
            this.printStack(event);
            return false;
        }
        TransitionPair[] transitions = null;
        try {
            transitions = this.node.getTransitions((State)this.current).transitions;
        }
        catch (InvalidParameterException e) {
            this.output.println("Internal Checker Error - InvalidParameterException");
            e.printStackTrace();
            return false;
        }
        catch (CheckingException e) {
            this.output.println("Internal Checker Error - CheckingException");
            e.printStackTrace();
            return false;
        }
        for (int i = 0; i < transitions.length; ++i) {
            if (transitions[i].eventIndex != action) continue;
            this.eventStack.push(event);
            this.stateStack.push(this.current);
            this.current = transitions[i].state;
            this.visitedState = false;
            try {
                this.globalCache.insert(this.current.getSignature());
            }
            catch (ItemAlreadyPresentException e) {
                this.visitedState = true;
            }
            found = true;
            if (!Options.monitorusage) break;
            ProtocolUsageMonitor.eventExecuted(transitions[i].eventIndex);
            break;
        }
        if (!found) {
            this.printStack(event);
            return false;
        }
        return true;
    }

    protected boolean undoStep(String event) {
        if (this.eventStack.peek().equals(event)) {
            this.eventStack.pop();
            this.current = (State)this.stateStack.peek();
            this.stateStack.pop();
            this.visitedState = true;
            return true;
        }
        this.printStack(event);
        return false;
    }
}

