/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.DFSR;

import java.util.Iterator;
import java.util.Stack;
import org.objectweb.fractal.bpc.checker.DFSR.AcceptingStateException;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.DFSR.DFSRPathItem;
import org.objectweb.fractal.bpc.checker.DFSR.IDFSRExtension;
import org.objectweb.fractal.bpc.checker.DFSR.InfiniteActivityException;
import org.objectweb.fractal.bpc.checker.DFSR.ItemAlreadyPresentException;
import org.objectweb.fractal.bpc.checker.DFSR.ItemNotPresentException;
import org.objectweb.fractal.bpc.checker.DFSR.Options;
import org.objectweb.fractal.bpc.checker.DFSR.StateCache;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.parser.Debug;
import org.objectweb.fractal.bpc.checker.state.Signature;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;

public class DFSRTraverser {
    private TreeNode node;
    private StateCache globalCache;
    private StateCache pathCache;
    private Stack pathStack;
    private ActionRepository repository;
    private boolean secondStage;

    public DFSRTraverser(TreeNode node, ActionRepository repository) {
        this.node = node;
        this.globalCache = Options.action == 1 || Options.action == 2 ? new StateCache(Options.statememory * (100000 / Signature.getSize())) : new StateCache(0);
        this.pathCache = new StateCache(0);
        this.pathStack = new Stack();
        this.repository = repository;
        this.secondStage = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IDFSRExtension implementation) throws InvalidParameterException, ItemAlreadyPresentException, ItemNotPresentException, CheckingException {
        Stack<DFSRPathItem> poppedstack = new Stack<DFSRPathItem>();
        long statecnt = 1L;
        State newstate = this.node.getInitial();
        TransitionPair[] inittrans = null;
        boolean popflag = false;
        this.pathStack.push(new DFSRPathItem(-1, inittrans, newstate));
        this.pathCache.insert(newstate.getSignature());
        this.globalCache.insert(newstate.getSignature());
        implementation.action(newstate);
        try {
            implementation.actionNew(newstate);
        }
        catch (AcceptingStateException e) {
            throw new AcceptingStateException("<initial state>");
        }
        Debug.print(3, "(S0) ");
        try {
            while (true) {
                int stateindex;
                State stackstate;
                Signature sig;
                Iterator it;
                DFSRPathItem currentstatetuple;
                block32: {
                    if (this.pathStack.size() <= 0) {
                        Debug.println(statecnt + " states visited.");
                        return;
                    }
                    currentstatetuple = (DFSRPathItem)this.pathStack.peek();
                    TransitionPair[] transitions = this.node.getTransitions((State)currentstatetuple.state).transitions;
                    if (currentstatetuple.stateIndex == -1) {
                        currentstatetuple.stateIndex = transitions.length;
                    }
                    if (popflag && currentstatetuple.stateIndex < transitions.length) {
                        Debug.println(3, this.repository.getItemString(transitions[currentstatetuple.stateIndex].eventIndex) + " ");
                        popflag = false;
                    }
                    if (currentstatetuple.stateIndex > 0) {
                        --currentstatetuple.stateIndex;
                        newstate = transitions[currentstatetuple.stateIndex].state;
                        Debug.print(3, this.repository.getItemString(transitions[currentstatetuple.stateIndex].eventIndex) + " ");
                        Debug.print(3, "\n(S" + statecnt + ") ");
                        if ((statecnt & 0x3FFL) == 0L) {
                            Debug.println(2, Long.toString(statecnt));
                            Debug.println(2, "Stack size:" + this.pathStack.size());
                        }
                        if (this.pathCache.isPresent(newstate.getSignature())) {
                            Debug.print(3, "cycle - staying current - ");
                            implementation.action(newstate);
                            if (Options.infiniteactivity == 1) continue;
                            it = this.pathStack.iterator();
                            sig = newstate.getSignature();
                            stackstate = null;
                            stateindex = 0;
                            break block32;
                        } else {
                            if (this.globalCache.isPresent(newstate.getSignature())) {
                                Debug.print(3, "back - ");
                                Debug.print(3, newstate.getSignature().toString());
                                implementation.action(newstate);
                                implementation.actionVisited(newstate);
                                if (Options.infiniteactivity != 1) {
                                    if (!currentstatetuple.state.isAcceptingReachable() && Options.infiniteactivity != 1 && this.globalCache.acceptingReach(newstate.getSignature())) {
                                        currentstatetuple.state.getSignature().setAcceptingReachable(true);
                                        this.globalCache.setAcceptingReach(currentstatetuple.state.getSignature());
                                        Debug.print(3, " accepting - ");
                                    }
                                    long oldid = currentstatetuple.state.getSignature().getCycleId();
                                    long newid = this.globalCache.getCycleId(newstate.getSignature());
                                    if (oldid == Long.MAX_VALUE || oldid > newid) {
                                        currentstatetuple.state.getSignature().setCycleId(newid);
                                        currentstatetuple.state.cycleStart = false;
                                        this.globalCache.updateItem(currentstatetuple.state.getSignature());
                                    }
                                }
                                Debug.println(3);
                                continue;
                            }
                            ++statecnt;
                            Debug.print(3, newstate.getSignature().toString());
                            implementation.action(newstate);
                            boolean isAccepting = false;
                            if (implementation.actionNew(newstate)) {
                                newstate.getSignature().setAcceptingReachable(true);
                                isAccepting = true;
                                Debug.print(3, "accepting - ");
                            }
                            DFSRPathItem newitem = new DFSRPathItem(-1, null, newstate);
                            this.pathStack.push(newitem);
                            this.pathCache.insert(newstate.getSignature());
                            this.globalCache.insert(newstate.getSignature());
                            if (Options.infiniteactivity == 1 || !isAccepting) continue;
                            this.globalCache.updateItem(newstate.getSignature());
                            continue;
                        }
                    }
                    popflag = true;
                    State current = currentstatetuple.state;
                    implementation.actionBack(current);
                    this.pathStack.pop();
                    if (this.pathStack.size() > 0 && Options.infiniteactivity != 1) {
                        State above = ((DFSRPathItem)this.pathStack.peek()).state;
                        Debug.print(3, current.isAcceptingReachable() ? "pop: accepting - " : "pop:not accepting - ");
                        Debug.print(3, current.label + " " + current.getSignature().toString() + " - ");
                        if (current.cycleStart && Options.action != 3) {
                            if (!current.isAcceptingReachable()) {
                                if (!this.secondStage && Options.infiniteactivity == 0) {
                                    popflag = false;
                                    Debug.println(2, "Infinite activity detected, reconstructing cycle trace");
                                    Debug.println(3, "Stack size: " + this.pathStack.size());
                                    Stack tmp = (Stack)this.pathStack.clone();
                                    this.completeStack(tmp, 0);
                                    ((DFSRPathItem)tmp.peek()).transitions = this.node.getTransitions((State)((DFSRPathItem)tmp.peek()).state).transitions;
                                    System.out.print("Prefix: " + DFSRTraverser.getStack(this.repository, this.shortenStack(tmp), 0));
                                    this.secondStage = true;
                                    currentstatetuple.stateIndex = -1;
                                    this.pathStack.push(currentstatetuple);
                                    this.globalCache.clear();
                                    this.pathCache.clear();
                                    implementation.reset();
                                    for (int i = 0; i < this.pathStack.size(); ++i) {
                                        Signature sig2 = ((DFSRPathItem)this.pathStack.get((int)i)).state.getSignature();
                                        this.globalCache.insert(sig2);
                                        this.pathCache.insert(sig2);
                                        implementation.actionNew(((DFSRPathItem)this.pathStack.get((int)i)).state);
                                    }
                                } else {
                                    this.node.getAnotatedProtocol(current).prettyPrint(true);
                                    this.completeStack(this.pathStack, 0);
                                    ((DFSRPathItem)this.pathStack.peek()).transitions = this.node.getTransitions((State)((DFSRPathItem)this.pathStack.peek()).state).transitions;
                                    System.out.println('(' + current.label + ')' + "\nCycle: " + (Options.infiniteactivity == 0 ? current.cycleTrace : "cycle trace no available, run with --infiniteactivity=yes"));
                                    throw new InfiniteActivityException("divergence.");
                                }
                            }
                        } else {
                            long aboveid = above.getSignature().getCycleId();
                            long currentid = current.getSignature().getCycleId();
                            if ((aboveid == Long.MAX_VALUE || aboveid > currentid) && currentid != Long.MAX_VALUE) {
                                above.getSignature().setCycleId(currentid);
                                above.cycleStart = false;
                                poppedstack.push(currentstatetuple);
                            }
                        }
                        if (!above.isAcceptingReachable() && current.isAcceptingReachable()) {
                            above.getSignature().setAcceptingReachable(true);
                            this.globalCache.updateItem(above.getSignature());
                        }
                    }
                    if (popflag) {
                        this.pathCache.remove(currentstatetuple.state.getSignature());
                    }
                    popflag = true;
                    continue;
                }
                while (it.hasNext() && !sig.equals((stackstate = ((DFSRPathItem)it.next()).state).getSignature())) {
                    ++stateindex;
                }
                Debug.println(3, stackstate.label);
                if (Options.infiniteactivity == 0 && this.secondStage) {
                    this.completeStack(this.pathStack, stateindex);
                    ((DFSRPathItem)this.pathStack.peek()).transitions = this.node.getTransitions((State)((DFSRPathItem)this.pathStack.peek()).state).transitions;
                    stackstate.cycleTrace = DFSRTraverser.getStack(this.repository, this.pathStack, stateindex) + "(" + stackstate.label + ")";
                }
                implementation.actionCycle(stackstate);
                long oldid = currentstatetuple.state.getSignature().getCycleId();
                long newid = stackstate.getSignature().getCycleId();
                if (oldid == Long.MAX_VALUE || oldid > newid) {
                    currentstatetuple.state.getSignature().setCycleId(newid);
                    currentstatetuple.state.cycleStart = false;
                    this.globalCache.updateItem(currentstatetuple.state.getSignature());
                }
                if (stateindex == this.pathStack.size()) {
                    stackstate.cycleStart = false;
                }
                if (currentstatetuple.state.isAcceptingReachable() || Options.infiniteactivity == 1 || !this.globalCache.acceptingReach(newstate.getSignature())) continue;
                currentstatetuple.state.getSignature().setAcceptingReachable(true);
                this.globalCache.setAcceptingReach(currentstatetuple.state.getSignature());
            }
        }
        catch (InfiniteActivityException e) {
            Debug.println(statecnt + " states visited (some of them are counted more than once).");
            this.node.getAnotatedProtocol(newstate).prettyPrint(true);
            throw e;
        }
        catch (CheckingException e) {
            Debug.println(statecnt + " states visited.");
            this.node.getAnotatedProtocol(newstate).prettyPrint(true);
            this.completeStack(this.pathStack, 0);
            throw e.addMessage(DFSRTraverser.getStack(this.repository, this.shortenStack(this.pathStack), 0));
        }
    }

    static String getStack(ActionRepository repository, Stack stack, int from) {
        String result = new String("\n");
        if (stack.size() == 1) {
            return "<initial state>";
        }
        for (int i = from; i < stack.size(); ++i) {
            DFSRPathItem item = (DFSRPathItem)stack.get(i);
            result = result + "(" + item.state.label + ")";
            if (item.stateIndex < 0 || item.transitions.length <= 0 || item.stateIndex >= item.transitions.length) continue;
            String event = repository.getItemString(item.transitions[item.stateIndex].eventIndex);
            if (event.charAt(0) != '[' && event.indexOf(60) != -1) {
                String method = event.substring(event.indexOf(46) + 1, event.length());
                String iface = event.substring(event.indexOf(45) + 1, event.indexOf(62));
                result = result + " " + event.charAt(0) + iface + "." + method + " \n";
                continue;
            }
            result = result + " " + event + " \n";
        }
        return result;
    }

    private Stack shortenStack(Stack stack) {
        for (int i = stack.size() - 1; i > 0; --i) {
            State higherstate = ((DFSRPathItem)stack.get((int)i)).state;
            block1: for (int j = 0; j < i - 1; ++j) {
                DFSRPathItem lower = (DFSRPathItem)stack.get(j);
                int transcnt = lower.transitions.length;
                for (int k = 0; k < transcnt; ++k) {
                    if (!lower.transitions[k].state.equals(higherstate)) continue;
                    for (int l = i - 1; l > j; --l) {
                        stack.removeElementAt(l);
                    }
                    lower.stateIndex = k;
                    i = j;
                    j = -1;
                    continue block1;
                }
            }
        }
        return stack;
    }

    private void completeStack(Stack stack, int stateindex) {
        for (int i = stateindex; i < stack.size() - 1; ++i) {
            DFSRPathItem item = (DFSRPathItem)stack.get(i);
            try {
                item.transitions = this.node.getTransitions((State)item.state).transitions;
                continue;
            }
            catch (CheckingException e) {
                System.out.println("Internal checker error");
                continue;
            }
            catch (InvalidParameterException e) {
                System.out.println("Internal checker error");
            }
        }
    }
}

