/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.bpc.checker.DFSR;

import java.io.FileOutputStream;
import java.io.IOException;
import org.objectweb.fractal.bpc.checker.DFSR.AcceptingStateException;
import org.objectweb.fractal.bpc.checker.DFSR.CheckingException;
import org.objectweb.fractal.bpc.checker.DFSR.IDFSRExtension;
import org.objectweb.fractal.bpc.checker.node.ActionRepository;
import org.objectweb.fractal.bpc.checker.node.InvalidParameterException;
import org.objectweb.fractal.bpc.checker.node.TreeNode;
import org.objectweb.fractal.bpc.checker.state.State;
import org.objectweb.fractal.bpc.checker.state.TransitionPair;

public class DFSRDotVis
implements IDFSRExtension {
    private FileOutputStream outputfile;
    private int timestamp = 0;
    private TreeNode automaton;
    private ActionRepository repository;

    public DFSRDotVis(FileOutputStream outputfile, TreeNode automaton, ActionRepository repository) {
        this.outputfile = outputfile;
        this.automaton = automaton;
        this.repository = repository;
    }

    public void action(State state) throws InvalidParameterException {
    }

    public boolean actionNew(State state) throws InvalidParameterException, CheckingException {
        state.label = new String("S" + this.timestamp);
        try {
            boolean acc = this.automaton.isAccepting(state);
            State initstate = this.automaton.getInitial();
            boolean init = initstate.getSignature().equals(state.getSignature());
            if (acc) {
                this.outputfile.write(("  \"" + state.getSignature() + "\" [label=\"S" + this.timestamp + "\", shape=doublecircle, style=filled, fillcolor=\"grey\"];\n").getBytes());
            } else {
                this.outputfile.write(("  \"" + state.getSignature() + "\" [label=\"S" + this.timestamp + "\"];\n").getBytes());
            }
            if (init) {
                if (acc) {
                    this.outputfile.write(("  \"" + state.getSignature() + "\" [shape=box, peripheries=2, style=filled, fillcolor=\"grey\"];\n").getBytes());
                } else {
                    this.outputfile.write(("  \"" + state.getSignature() + "\" [shape=box];\n").getBytes());
                }
            }
            TransitionPair[] trans = this.automaton.getTransitions((State)state).transitions;
            for (int i = 0; i < trans.length; ++i) {
                this.outputfile.write(("  \"" + state.getSignature() + "\" -> \"" + trans[i].state.getSignature() + "\" [label=\"" + this.repository.getItemString(trans[i].eventIndex) + "\"];\n").getBytes());
            }
        }
        catch (IOException e) {
            throw new AcceptingStateException("Visualization backend: error while writing to the file.");
        }
        state.timestamp = this.timestamp++;
        return this.automaton.isAccepting(state);
    }

    public void actionCycle(State state) throws InvalidParameterException {
        if (state.getSignature().getCycleId() == Long.MAX_VALUE) {
            state.cycleStart = true;
            state.getSignature().setCycleId(state.timestamp);
        }
    }

    public void actionVisited(State state) throws InvalidParameterException {
    }

    public void actionBack(State state) throws InvalidParameterException {
        try {
            if (state.isAcceptingReachable()) {
                this.outputfile.write(("  \"" + state.getSignature() + "\" [style=filled, fillcolor=\"grey\"];\n").getBytes());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() {
        this.timestamp = 0;
    }
}

