/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import sun.misc.SharedSecrets;

public class AnnotationType {
    private RetentionPolicy retention = RetentionPolicy.RUNTIME;
    private boolean inherited = false;
    private final Map<String, Class<?>> memberTypes = new HashMap();
    private final Map<String, Object> memberDefaults = new HashMap<String, Object>();
    private final Map<String, Method> members = new HashMap<String, Method>();

    public static synchronized AnnotationType getInstance(Class<?> annotationClass) {
        AnnotationType at = SharedSecrets.getJavaLangAccess().getAnnotationType(annotationClass);
        if (at == null) {
            at = new AnnotationType(annotationClass);
        }
        return at;
    }

    private AnnotationType(Class<?> annoCls) {
        Method[] methods;
        if (!annoCls.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type");
        }
        for (Method m : methods = annoCls.getDeclaredMethods()) {
            if (m.getParameterTypes().length != 0) continue;
            String mname = m.getName();
            this.members.put(mname, m);
            Class<?> type = m.getReturnType();
            this.memberTypes.put(mname, AnnotationType.invocationHandlerReturnType(type));
            Object val = m.getDefaultValue();
            if (val == null) continue;
            this.memberDefaults.put(mname, val);
        }
        if (annoCls != Retention.class && annoCls != Inherited.class) {
            this.inherited = annoCls.isAnnotationPresent(Inherited.class);
            Retention r = annoCls.getAnnotation(Retention.class);
            this.retention = r == null ? RetentionPolicy.CLASS : r.value();
        }
        SharedSecrets.getJavaLangAccess().setAnnotationType(annoCls, this);
    }

    public static Class<?> invocationHandlerReturnType(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return type;
    }

    public Map<String, Class<?>> memberTypes() {
        return this.memberTypes;
    }

    public Map<String, Method> members() {
        return this.members;
    }

    public Map<String, Object> memberDefaults() {
        return this.memberDefaults;
    }

    public RetentionPolicy retention() {
        return this.retention;
    }

    public boolean isInherited() {
        return this.inherited;
    }
}

