/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gov.nasa.jpf.jvm.abstraction.filter.FilterField;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileDescriptor {
    @FilterField
    int fd;
    static final int FD_READ = 0;
    static final int FD_WRITE = 1;
    static final int FD_NEW = 0;
    static final int FD_OPENED = 1;
    static final int FD_CLOSED = 2;
    String fileName;
    int mode;
    int state = 0;
    long off;

    public FileDescriptor() {
        this.fd = -1;
    }

    FileDescriptor(String fname, int mode) throws IOException, FileNotFoundException {
        this.fileName = fname;
        this.mode = mode;
        this.fd = this.open(fname, mode);
        if (this.fd == -1) {
            throw new FileNotFoundException(fname);
        }
        this.state = 1;
    }

    public boolean valid() {
        return this.fd != -1;
    }

    public void close() throws IOException {
        this.close0();
        this.state = 2;
    }

    native int open(String var1, int var2) throws IOException;

    public native void sync();

    native int read() throws IOException;

    native int read(byte[] var1, int var2, int var3);

    native long skip(long var1) throws IOException;

    native int available() throws IOException;

    native void close0() throws IOException;

    native void write(int var1) throws IOException;

    native void write(byte[] var1, int var2, int var3);
}

