/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.envgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ow2.dsrg.fm.tbpjava.envgen.Indenter;
import org.ow2.dsrg.fm.tbpjava.utils.Configuration;
import org.ow2.dsrg.fm.tbpjava.utils.Type2String;

public class StubGenerator {
    private static final boolean DEBUG = false;
    private String reqItfsName;
    private Configuration config;
    private PrintStream infoStream;
    private String stubClassName;
    private String stubClassFullName;
    public static final String CLASS_NAME_SUFFIX = "_stub";
    public static final String METHOD_PARAMETER_PREFIX = "p";
    public static final String PROPERTY_OBTAIN_VALUES = "envValues";
    public static final String PROPERTY_OBTAIN_VALUES_TYPE = "EnvValueSets";

    public StubGenerator(Configuration config, String reqItfsName, PrintStream outStream) {
        this.config = config;
        this.reqItfsName = reqItfsName;
        this.infoStream = outStream;
        this.stubClassFullName = StubGenerator.getGeneratedClassFullName(reqItfsName, config);
        this.stubClassName = StubGenerator.getClassName(this.stubClassFullName);
    }

    public String generateStub() {
        PrintStream stubStream = null;
        String stubFileName = this.config.getEnvTargetDir() + this.stubClassFullName.replace('.', '/') + ".java";
        try {
            StubGenerator.generateDirectoryStructureForFile(stubFileName);
            stubStream = new PrintStream(stubFileName);
        }
        catch (FileNotFoundException e) {
            this.infoStream.println("Generating stub " + this.stubClassName + " failed. File creation error.");
            return null;
        }
        Indenter indenter = new Indenter(stubStream);
        String reqitfClassName = this.config.getComponentRequiredInterfaces().get(this.reqItfsName);
        if (reqitfClassName == null) {
            this.infoStream.println("Generating stub " + this.stubClassName + " failed. Name of interface for required interface " + this.reqItfsName + " can't be resolved. ");
            stubStream.close();
            return null;
        }
        Class<?> reqitfClass = null;
        try {
            reqitfClass = Thread.currentThread().getContextClassLoader().loadClass(Type2String.removeGenerics(reqitfClassName));
        }
        catch (ClassNotFoundException e) {
            this.infoStream.println("Generating stub " + this.stubClassName + " failed. Interface class " + reqitfClassName + " not found.");
            stubStream.close();
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PROPERTY_OBTAIN_VALUES, PROPERTY_OBTAIN_VALUES_TYPE);
        StubGenerator.genInitialClassCode(stubStream, indenter, this.stubClassName, reqitfClassName, reqitfClass.getTypeParameters(), this.config);
        StubGenerator.genProperties(stubStream, indenter, params);
        StubGenerator.genConstructor(stubStream, indenter, this.stubClassName, params);
        for (Method method : reqitfClass.getMethods()) {
            StubGenerator.genMethod(stubStream, indenter, method, this.config.getComponentName(), reqitfClassName);
        }
        StubGenerator.genEndingClassCode(stubStream, indenter);
        stubStream.close();
        return this.stubClassFullName;
    }

    public static String getPackage(String objectFullName) {
        if (objectFullName == null) {
            return null;
        }
        int pos = (objectFullName = Type2String.removeGenerics(objectFullName)).lastIndexOf(46);
        if (pos == -1) {
            return null;
        }
        return objectFullName.substring(0, pos);
    }

    public static String getClassName(String objectFullName) {
        int pos = (objectFullName = Type2String.removeGenerics(objectFullName)).lastIndexOf(46);
        if (pos == -1) {
            return objectFullName;
        }
        return objectFullName.substring(pos + 1);
    }

    private static void genInitialClassCode(PrintStream stubStream, Indenter indenter, String stubClassName, String reqItfsClassName, Type[] genericTypes, Configuration config) {
        String pkgReqitf = StubGenerator.getPackage(reqItfsClassName);
        if (pkgReqitf != null) {
            indenter.indent();
            stubStream.println("package " + StubGenerator.getPackage(reqItfsClassName) + ";");
        } else {
            indenter.indent();
            stubStream.println("// default package;");
        }
        indenter.indent();
        stubStream.println();
        indenter.indent();
        stubStream.println("import org.ow2.dsrg.fm.tbpjava.envgen.EnvValueSets;");
        indenter.indent();
        stubStream.println();
        for (String compImplClass : config.getComponentImplementationClasses()) {
            String pkgComponent = StubGenerator.getPackage(compImplClass);
            if (pkgComponent != null) {
                indenter.indent();
                stubStream.println("import " + pkgComponent + ".*;");
                continue;
            }
            indenter.indent();
            stubStream.println("// Component implementation in default package ... no import;");
        }
        indenter.indent();
        stubStream.println();
        indenter.indent();
        stubStream.println();
        indenter.indent();
        stubStream.println("public class " + stubClassName + Type2String.getGenericTypeDefinition(genericTypes) + " implements " + Type2String.removeGenerics(reqItfsClassName) + Type2String.getGenericsTypeNames(genericTypes) + " {");
        indenter.addLevel();
        indenter.indent();
        stubStream.println();
    }

    private static void genProperties(PrintStream stubStream, Indenter indenter, Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propName = entry.getKey();
            String className = entry.getValue();
            indenter.indent();
            stubStream.println("private " + className + " " + propName + ";");
            indenter.indent();
        }
    }

    private static void genConstructor(PrintStream stubStream, Indenter indenter, String stubClassName, Map<String, String> parameters) {
        Set<String> propertyNames = parameters.keySet();
        indenter.indent();
        stubStream.println();
        indenter.indent();
        stubStream.print("public " + stubClassName + "(");
        boolean firstParam = true;
        for (String propName : propertyNames) {
            if (firstParam) {
                firstParam = false;
            } else {
                stubStream.print(", ");
            }
            stubStream.print(parameters.get(propName) + " " + propName);
        }
        stubStream.println(") {");
        indenter.addLevel();
        for (String propName : propertyNames) {
            indenter.indent();
            stubStream.println("this." + propName + " = " + propName + ";");
        }
        indenter.removeLevel();
        indenter.indent();
        stubStream.println("}");
    }

    private static void genMethod(PrintStream stubStream, Indenter indenter, Method method, String componentName, String itfsName) {
        Annotation[] annotations;
        indenter.indent();
        stubStream.println();
        for (Annotation annot : annotations = method.getAnnotations()) {
            indenter.indent();
            stubStream.println(((Object)annot).toString());
        }
        int methodModifiers = method.getModifiers();
        indenter.indent();
        stubStream.print(Modifier.toString(methodModifiers &= 0xFFFFFBFF) + " ");
        stubStream.print(Type2String.getGenericTypeDefinition(method.getTypeParameters()) + " ");
        stubStream.print(Type2String.getTypeName(method.getGenericReturnType()) + " ");
        stubStream.print(method.getName() + "(");
        Type[] params = method.getGenericParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                stubStream.print(", ");
            }
            stubStream.print(Type2String.getTypeName(params[i]) + " " + METHOD_PARAMETER_PREFIX + Integer.toString(i));
        }
        stubStream.print(")");
        Type[] exceptions = method.getGenericExceptionTypes();
        if (exceptions.length > 0) {
            stubStream.print(" throws");
            for (int i1 = 0; i1 < exceptions.length; ++i1) {
                if (i1 > 0) {
                    stubStream.print(",");
                }
                stubStream.print(" " + Type2String.getTypeName(exceptions[i1]));
            }
        }
        stubStream.println(" {");
        indenter.addLevel();
        indenter.indent();
        stubStream.print("return" + StubGenerator.genMethodReturnValue(method, componentName, itfsName));
        stubStream.print(";");
        stubStream.println();
        indenter.removeLevel();
        indenter.indent();
        stubStream.println("}");
    }

    private static String genMethodReturnValue(Method method, String componentName, String itfsName) {
        String result = StubGenerator.genCodeObtainingValue(method.getGenericReturnType(), componentName, itfsName, method.getName());
        if (!result.isEmpty()) {
            result = ' ' + result;
        }
        return result;
    }

    public static String genCodeObtainingValue(Type type, String componentName, String itfsName, String methodName) {
        StringBuffer retVal = new StringBuffer();
        if (type.equals(Void.TYPE)) {
            return "";
        }
        if (StubGenerator.envValSetUseObject(type)) {
            retVal.append('(');
            retVal.append(Type2String.getTypeName(type));
            retVal.append(')');
            retVal.append(' ');
        }
        retVal.append(PROPERTY_OBTAIN_VALUES);
        retVal.append('.');
        if (type.equals(Boolean.TYPE)) {
            retVal.append("getBoolean");
        } else if (type.equals(Byte.TYPE)) {
            retVal.append("getByte");
        } else if (type.equals(Short.TYPE)) {
            retVal.append("getShort");
        } else if (type.equals(Integer.TYPE)) {
            retVal.append("getInt");
        } else if (type.equals(Long.TYPE)) {
            retVal.append("getLong");
        } else if (type.equals(Character.TYPE)) {
            retVal.append("getChar");
        } else if (type.equals(Float.TYPE)) {
            retVal.append("getFloat");
        } else if (type.equals(Double.TYPE)) {
            retVal.append("getDouble");
        } else if (type.equals(String.class)) {
            retVal.append("getString");
        } else {
            retVal.append("getObject");
        }
        retVal.append("(\"");
        if (StubGenerator.envValSetUseObject(type)) {
            retVal.append(Type2String.getTypeName(type));
            retVal.append("\", \"");
        }
        retVal.append(componentName);
        retVal.append("\", \"");
        retVal.append(itfsName);
        retVal.append("\", \"");
        retVal.append(methodName);
        retVal.append("\")");
        return retVal.toString();
    }

    private static boolean isTypePrimitive(Type type) {
        return type.equals(Boolean.TYPE) || type.equals(Byte.TYPE) || type.equals(Short.TYPE) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Character.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE);
    }

    private static boolean envValSetUseObject(Type type) {
        return !StubGenerator.isTypePrimitive(type) && !type.equals(String.class);
    }

    private static void genEndingClassCode(PrintStream stubStream, Indenter indenter) {
        indenter.indent();
        stubStream.println();
        indenter.removeLevel();
        indenter.indent();
        stubStream.println("}");
        indenter.indent();
        stubStream.println();
    }

    public static String getGeneratedClassFullName(String reqItfsName, Configuration config) {
        String reqitfClassPackageName = StubGenerator.getPackage(config.getComponentRequiredInterfaces().get(reqItfsName));
        reqitfClassPackageName = reqitfClassPackageName == null ? "" : reqitfClassPackageName + ".";
        return reqitfClassPackageName + reqItfsName + CLASS_NAME_SUFFIX;
    }

    public static void generateDirectoryStructureForFile(String fileName) {
        File file = new File(fileName);
        File dir = file.getParentFile();
        dir.mkdirs();
    }
}

